rule win_confucius_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.confucius."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.confucius"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0101 eb11 8b442424 50 }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   eb11                 | jmp                 0x13
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   50                   | push                eax

        $sequence_1 = { 8b4e08 e8???????? 8bf8 3bfb 741c }
            // n = 5, score = 100
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   3bfb                 | cmp                 edi, ebx
            //   741c                 | je                  0x1e

        $sequence_2 = { 391d???????? 7521 8b3d???????? 6aff 53 }
            // n = 5, score = 100
            //   391d????????         |                     
            //   7521                 | jne                 0x23
            //   8b3d????????         |                     
            //   6aff                 | push                -1
            //   53                   | push                ebx

        $sequence_3 = { 00801d430023 d18a0688078a 46 018847018a46 }
            // n = 4, score = 100
            //   00801d430023         | add                 byte ptr [eax + 0x2300431d], al
            //   d18a0688078a         | ror                 dword ptr [edx - 0x75f877fa], 1
            //   46                   | inc                 esi
            //   018847018a46         | add                 dword ptr [eax + 0x468a0147], ecx

        $sequence_4 = { 50 8915???????? e8???????? a3???????? 8d44242c }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8915????????         |                     
            //   e8????????           |                     
            //   a3????????           |                     
            //   8d44242c             | lea                 eax, [esp + 0x2c]

        $sequence_5 = { 6a01 8d45fc 50 8d45fc }
            // n = 4, score = 100
            //   6a01                 | push                1
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_6 = { 8935???????? 8b35???????? 57 ffd6 ff35???????? }
            // n = 5, score = 100
            //   8935????????         |                     
            //   8b35????????         |                     
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   ff35????????         |                     

        $sequence_7 = { 0203 0405 0206 07 089090909090 }
            // n = 5, score = 100
            //   0203                 | add                 al, byte ptr [ebx]
            //   0405                 | add                 al, 5
            //   0206                 | add                 al, byte ptr [esi]
            //   07                   | pop                 es
            //   089090909090         | or                  byte ptr [eax - 0x6f6f6f70], dl

        $sequence_8 = { 0103 33c0 5f 5e 5d }
            // n = 5, score = 100
            //   0103                 | add                 dword ptr [ebx], eax
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_9 = { 0101 eb21 8b4c2420 c744241000000000 }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   eb21                 | jmp                 0x23
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0

        $sequence_10 = { 0344242c 8d940297ff2a43 8bc2 c1e816 }
            // n = 4, score = 100
            //   0344242c             | add                 eax, dword ptr [esp + 0x2c]
            //   8d940297ff2a43       | lea                 edx, [edx + eax + 0x432aff97]
            //   8bc2                 | mov                 eax, edx
            //   c1e816               | shr                 eax, 0x16

        $sequence_11 = { 6a00 68c2000000 ff75fc ffd6 57 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   68c2000000           | push                0xc2
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd6                 | call                esi
            //   57                   | push                edi

        $sequence_12 = { 030b 51 50 ff15???????? }
            // n = 4, score = 100
            //   030b                 | add                 ecx, dword ptr [ebx]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_13 = { 837d5400 894578 894d24 898c3514ffffff }
            // n = 4, score = 100
            //   837d5400             | cmp                 dword ptr [ebp + 0x54], 0
            //   894578               | mov                 dword ptr [ebp + 0x78], eax
            //   894d24               | mov                 dword ptr [ebp + 0x24], ecx
            //   898c3514ffffff       | mov                 dword ptr [ebp + esi - 0xec], ecx

        $sequence_14 = { 018118030000 8b442410 8b4c2420 5f }
            // n = 4, score = 100
            //   018118030000         | add                 dword ptr [ecx + 0x318], eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   5f                   | pop                 edi

        $sequence_15 = { 48 f7d8 1ac0 fec0 7428 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   f7d8                 | neg                 eax
            //   1ac0                 | sbb                 al, al
            //   fec0                 | inc                 al
            //   7428                 | je                  0x2a

    condition:
        7 of them and filesize < 598016
}