rule win_contopee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.contopee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.contopee"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b35???????? 8d4c2414 6a5c 51 }
            // n = 4, score = 100
            //   8b35????????         |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   6a5c                 | push                0x5c
            //   51                   | push                ecx

        $sequence_1 = { 8d4c2414 6a5c 51 ffd6 83c410 85c0 7411 }
            // n = 7, score = 100
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   6a5c                 | push                0x5c
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13

        $sequence_2 = { 84c0 752f a0???????? 84c0 7409 }
            // n = 5, score = 100
            //   84c0                 | test                al, al
            //   752f                 | jne                 0x31
            //   a0????????           |                     
            //   84c0                 | test                al, al
            //   7409                 | je                  0xb

        $sequence_3 = { c1ea18 33c3 8b1c9530ea0010 33c3 8b1c8d30f60010 33c3 }
            // n = 6, score = 100
            //   c1ea18               | shr                 edx, 0x18
            //   33c3                 | xor                 eax, ebx
            //   8b1c9530ea0010       | mov                 ebx, dword ptr [edx*4 + 0x1000ea30]
            //   33c3                 | xor                 eax, ebx
            //   8b1c8d30f60010       | mov                 ebx, dword ptr [ecx*4 + 0x1000f630]
            //   33c3                 | xor                 eax, ebx

        $sequence_4 = { c3 68b80b0000 ff15???????? e8???????? 8bd8 85db 0f8514010000 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   68b80b0000           | push                0xbb8
            //   ff15????????         |                     
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   0f8514010000         | jne                 0x11a

        $sequence_5 = { c1e807 33d2 8a9094130110 8bc2 66ff848688090000 8b869c160000 8b96a0160000 }
            // n = 7, score = 100
            //   c1e807               | shr                 eax, 7
            //   33d2                 | xor                 edx, edx
            //   8a9094130110         | mov                 dl, byte ptr [eax + 0x10011394]
            //   8bc2                 | mov                 eax, edx
            //   66ff848688090000     | inc                 word ptr [esi + eax*4 + 0x988]
            //   8b869c160000         | mov                 eax, dword ptr [esi + 0x169c]
            //   8b96a0160000         | mov                 edx, dword ptr [esi + 0x16a0]

        $sequence_6 = { 668b88780a0110 898a8c000000 33c9 668b887c0a0110 898a90000000 33c9 668b887e0a0110 }
            // n = 7, score = 100
            //   668b88780a0110       | mov                 cx, word ptr [eax + 0x10010a78]
            //   898a8c000000         | mov                 dword ptr [edx + 0x8c], ecx
            //   33c9                 | xor                 ecx, ecx
            //   668b887c0a0110       | mov                 cx, word ptr [eax + 0x10010a7c]
            //   898a90000000         | mov                 dword ptr [edx + 0x90], ecx
            //   33c9                 | xor                 ecx, ecx
            //   668b887e0a0110       | mov                 cx, word ptr [eax + 0x10010a7e]

        $sequence_7 = { 5b 81c418010000 c3 56 68???????? 6a00 }
            // n = 6, score = 100
            //   5b                   | pop                 ebx
            //   81c418010000         | add                 esp, 0x118
            //   c3                   | ret                 
            //   56                   | push                esi
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_8 = { 7563 8b4c2410 8d442400 56 50 8d1409 8b4c2414 }
            // n = 7, score = 100
            //   7563                 | jne                 0x65
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8d442400             | lea                 eax, [esp]
            //   56                   | push                esi
            //   50                   | push                eax
            //   8d1409               | lea                 edx, [ecx + ecx]
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]

        $sequence_9 = { b980000000 33c0 8d7c241c 6a1e }
            // n = 4, score = 100
            //   b980000000           | mov                 ecx, 0x80
            //   33c0                 | xor                 eax, eax
            //   8d7c241c             | lea                 edi, [esp + 0x1c]
            //   6a1e                 | push                0x1e

    condition:
        7 of them and filesize < 180224
}