rule win_corebot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.corebot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.corebot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7df0 8d55f0 e8???????? 85c0 7411 837df000 }
            // n = 6, score = 1100
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0

        $sequence_1 = { c7411407000000 8d4910 89c6 01c0 c1ee07 }
            // n = 5, score = 1100
            //   c7411407000000       | mov                 dword ptr [ecx + 0x14], 7
            //   8d4910               | lea                 ecx, [ecx + 0x10]
            //   89c6                 | mov                 esi, eax
            //   01c0                 | add                 eax, eax
            //   c1ee07               | shr                 esi, 7

        $sequence_2 = { 8932 5e c3 31c0 ebfa 55 89e5 }
            // n = 7, score = 1100
            //   8932                 | mov                 dword ptr [edx], esi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   31c0                 | xor                 eax, eax
            //   ebfa                 | jmp                 0xfffffffc
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp

        $sequence_3 = { 8a1c08 84db 741c 01c8 }
            // n = 4, score = 1100
            //   8a1c08               | mov                 bl, byte ptr [eax + ecx]
            //   84db                 | test                bl, bl
            //   741c                 | je                  0x1e
            //   01c8                 | add                 eax, ecx

        $sequence_4 = { 8b06 85c0 743d 8b4e04 85c9 751a 83c604 }
            // n = 7, score = 1100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   85c0                 | test                eax, eax
            //   743d                 | je                  0x3f
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   85c9                 | test                ecx, ecx
            //   751a                 | jne                 0x1c
            //   83c604               | add                 esi, 4

        $sequence_5 = { 50 ff15???????? 85c0 7418 8b0e 6a00 ff750c }
            // n = 7, score = 1100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   6a00                 | push                0
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_6 = { 894dd8 b907000000 0fb618 895de8 }
            // n = 4, score = 1100
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx
            //   b907000000           | mov                 ecx, 7
            //   0fb618               | movzx               ebx, byte ptr [eax]
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx

        $sequence_7 = { 85c0 894dec 7405 8b55e8 eb2c 8b45dc }
            // n = 6, score = 1100
            //   85c0                 | test                eax, eax
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   7405                 | je                  7
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   eb2c                 | jmp                 0x2e
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]

        $sequence_8 = { e8???????? 807e5800 7509 ff7654 ff15???????? 807e5000 7509 }
            // n = 7, score = 1000
            //   e8????????           |                     
            //   807e5800             | cmp                 byte ptr [esi + 0x58], 0
            //   7509                 | jne                 0xb
            //   ff7654               | push                dword ptr [esi + 0x54]
            //   ff15????????         |                     
            //   807e5000             | cmp                 byte ptr [esi + 0x50], 0
            //   7509                 | jne                 0xb

        $sequence_9 = { ff7010 ff7014 e8???????? 8b45e0 }
            // n = 4, score = 1000
            //   ff7010               | push                dword ptr [eax + 0x10]
            //   ff7014               | push                dword ptr [eax + 0x14]
            //   e8????????           |                     
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]

        $sequence_10 = { eb10 6800800000 6a00 56 }
            // n = 4, score = 1000
            //   eb10                 | jmp                 0x12
            //   6800800000           | push                0x8000
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_11 = { ff15???????? 8d4634 50 ff15???????? 8d4e0c e8???????? }
            // n = 6, score = 1000
            //   ff15????????         |                     
            //   8d4634               | lea                 eax, [esi + 0x34]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d4e0c               | lea                 ecx, [esi + 0xc]
            //   e8????????           |                     

        $sequence_12 = { ff15???????? 807e5000 7509 ff764c ff15???????? 8d4634 50 }
            // n = 7, score = 1000
            //   ff15????????         |                     
            //   807e5000             | cmp                 byte ptr [esi + 0x50], 0
            //   7509                 | jne                 0xb
            //   ff764c               | push                dword ptr [esi + 0x4c]
            //   ff15????????         |                     
            //   8d4634               | lea                 eax, [esi + 0x34]
            //   50                   | push                eax

        $sequence_13 = { 85ff 740f 57 ff7508 }
            // n = 4, score = 1000
            //   85ff                 | test                edi, edi
            //   740f                 | je                  0x11
            //   57                   | push                edi
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_14 = { ff742428 e8???????? 8b442424 8d4c2410 }
            // n = 4, score = 1000
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   e8????????           |                     
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   8d4c2410             | lea                 ecx, [esp + 0x10]

        $sequence_15 = { 85c0 7515 8b4624 3b4620 }
            // n = 4, score = 1000
            //   85c0                 | test                eax, eax
            //   7515                 | jne                 0x17
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   3b4620               | cmp                 eax, dword ptr [esi + 0x20]

    condition:
        7 of them and filesize < 1302528
}