rule win_coredn_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.coredn."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.coredn"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 56 8d45fc 8bf1 50 e8???????? 85c0 }
            // n = 7, score = 600
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   8bf1                 | mov                 esi, ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_1 = { 8b7508 ba04010000 2bf1 6690 }
            // n = 4, score = 400
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   ba04010000           | mov                 edx, 0x104
            //   2bf1                 | sub                 esi, ecx
            //   6690                 | nop                 

        $sequence_2 = { 84c0 7415 8801 41 83ea01 }
            // n = 5, score = 400
            //   84c0                 | test                al, al
            //   7415                 | je                  0x17
            //   8801                 | mov                 byte ptr [ecx], al
            //   41                   | inc                 ecx
            //   83ea01               | sub                 edx, 1

        $sequence_3 = { 5e 8be5 5d c20400 85c9 7506 48 }
            // n = 7, score = 400
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   85c9                 | test                ecx, ecx
            //   7506                 | jne                 8
            //   48                   | dec                 eax

        $sequence_4 = { 8a1c06 84db 741c 8818 4a 40 83e901 }
            // n = 7, score = 400
            //   8a1c06               | mov                 bl, byte ptr [esi + eax]
            //   84db                 | test                bl, bl
            //   741c                 | je                  0x1e
            //   8818                 | mov                 byte ptr [eax], bl
            //   4a                   | dec                 edx
            //   40                   | inc                 eax
            //   83e901               | sub                 ecx, 1

        $sequence_5 = { 0f1f440000 3811 7408 41 83e801 75f6 eb04 }
            // n = 7, score = 400
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   3811                 | cmp                 byte ptr [ecx], dl
            //   7408                 | je                  0xa
            //   41                   | inc                 ecx
            //   83e801               | sub                 eax, 1
            //   75f6                 | jne                 0xfffffff8
            //   eb04                 | jmp                 6

        $sequence_6 = { 41 83ea01 75e7 8851ff b87a000780 5e }
            // n = 6, score = 400
            //   41                   | inc                 ecx
            //   83ea01               | sub                 edx, 1
            //   75e7                 | jne                 0xffffffe9
            //   8851ff               | mov                 byte ptr [ecx - 1], dl
            //   b87a000780           | mov                 eax, 0x8007007a
            //   5e                   | pop                 esi

        $sequence_7 = { 75ec 48 bf7a000780 8808 8bc7 5f 5b }
            // n = 7, score = 400
            //   75ec                 | jne                 0xffffffee
            //   48                   | dec                 eax
            //   bf7a000780           | mov                 edi, 0x8007007a
            //   8808                 | mov                 byte ptr [eax], cl
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_8 = { 85d2 7417 0fb73407 6685f6 740e }
            // n = 5, score = 200
            //   85d2                 | test                edx, edx
            //   7417                 | je                  0x19
            //   0fb73407             | movzx               esi, word ptr [edi + eax]
            //   6685f6               | test                si, si
            //   740e                 | je                  0x10

        $sequence_9 = { d3c8 3305???????? 3905???????? 0f8594070000 }
            // n = 4, score = 200
            //   d3c8                 | ror                 eax, cl
            //   3305????????         |                     
            //   3905????????         |                     
            //   0f8594070000         | jne                 0x79a

        $sequence_10 = { 83e13f c1f806 6bc930 8b048508414100 }
            // n = 4, score = 200
            //   83e13f               | and                 ecx, 0x3f
            //   c1f806               | sar                 eax, 6
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b048508414100       | mov                 eax, dword ptr [eax*4 + 0x414108]

        $sequence_11 = { 8b30 8bd6 c1fa06 8bc6 83e03f 6bc830 8b049508414100 }
            // n = 7, score = 200
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   8bd6                 | mov                 edx, esi
            //   c1fa06               | sar                 edx, 6
            //   8bc6                 | mov                 eax, esi
            //   83e03f               | and                 eax, 0x3f
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b049508414100       | mov                 eax, dword ptr [edx*4 + 0x414108]

        $sequence_12 = { eb57 53 8b1c85e8dd4000 56 6800080000 6a00 53 }
            // n = 7, score = 200
            //   eb57                 | jmp                 0x59
            //   53                   | push                ebx
            //   8b1c85e8dd4000       | mov                 ebx, dword ptr [eax*4 + 0x40dde8]
            //   56                   | push                esi
            //   6800080000           | push                0x800
            //   6a00                 | push                0
            //   53                   | push                ebx

        $sequence_13 = { b802000000 833d????????00 0f85b00a0000 8d0d60104100 }
            // n = 4, score = 200
            //   b802000000           | mov                 eax, 2
            //   833d????????00       |                     
            //   0f85b00a0000         | jne                 0xab6
            //   8d0d60104100         | lea                 ecx, [0x411060]

        $sequence_14 = { 8b0c8d08414100 c644112800 85f6 740c 56 }
            // n = 5, score = 200
            //   8b0c8d08414100       | mov                 ecx, dword ptr [ecx*4 + 0x414108]
            //   c644112800           | mov                 byte ptr [ecx + edx + 0x28], 0
            //   85f6                 | test                esi, esi
            //   740c                 | je                  0xe
            //   56                   | push                esi

    condition:
        7 of them and filesize < 270336
}