rule win_coreshell_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.coreshell."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.coreshell"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 ff15???????? 83c40c 3bc6 }
            // n = 4, score = 1000
            //   56                   | push                esi
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   3bc6                 | cmp                 eax, esi

        $sequence_1 = { 6810270000 ff15???????? be06000000 e8???????? 85c0 7401 4e }
            // n = 7, score = 1000
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   be06000000           | mov                 esi, 6
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7401                 | je                  3
            //   4e                   | dec                 esi

        $sequence_2 = { 68???????? 52 ffd7 ffd0 }
            // n = 4, score = 1000
            //   68????????           |                     
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   ffd0                 | call                eax

        $sequence_3 = { 6a00 ff15???????? 8bf0 ff15???????? 50 68???????? 68???????? }
            // n = 7, score = 800
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     

        $sequence_4 = { 8d041e 50 57 6a08 51 ff15???????? 8bf8 }
            // n = 7, score = 800
            //   8d041e               | lea                 eax, [esi + ebx]
            //   50                   | push                eax
            //   57                   | push                edi
            //   6a08                 | push                8
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_5 = { 6804010000 6a08 8b15???????? 52 ff15???????? }
            // n = 5, score = 800
            //   6804010000           | push                0x104
            //   6a08                 | push                8
            //   8b15????????         |                     
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_6 = { 8b0d???????? 8b15???????? 6a01 51 68???????? 52 }
            // n = 6, score = 800
            //   8b0d????????         |                     
            //   8b15????????         |                     
            //   6a01                 | push                1
            //   51                   | push                ecx
            //   68????????           |                     
            //   52                   | push                edx

        $sequence_7 = { c20400 50 a1???????? 6a00 50 }
            // n = 5, score = 800
            //   c20400               | ret                 4
            //   50                   | push                eax
            //   a1????????           |                     
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_8 = { e8???????? 85c0 7402 eb14 c745f000000000 68e0930400 ff15???????? }
            // n = 7, score = 700
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7402                 | je                  4
            //   eb14                 | jmp                 0x16
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   68e0930400           | push                0x493e0
            //   ff15????????         |                     

        $sequence_9 = { 8d4c2400 56 51 6a00 }
            // n = 4, score = 700
            //   8d4c2400             | lea                 ecx, [esp]
            //   56                   | push                esi
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_10 = { 50 a3???????? ffd6 a3???????? }
            // n = 4, score = 700
            //   50                   | push                eax
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   a3????????           |                     

        $sequence_11 = { 8bf1 8b4604 85c0 7407 50 ff15???????? 8b36 }
            // n = 7, score = 700
            //   8bf1                 | mov                 esi, ecx
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b36                 | mov                 esi, dword ptr [esi]

        $sequence_12 = { ff15???????? ffd0 85c0 7508 }
            // n = 4, score = 700
            //   ff15????????         |                     
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa

        $sequence_13 = { 8b0d???????? 52 50 57 68???????? }
            // n = 5, score = 600
            //   8b0d????????         |                     
            //   52                   | push                edx
            //   50                   | push                eax
            //   57                   | push                edi
            //   68????????           |                     

        $sequence_14 = { 68???????? 6800080000 8d85fcefffff 50 }
            // n = 4, score = 600
            //   68????????           |                     
            //   6800080000           | push                0x800
            //   8d85fcefffff         | lea                 eax, [ebp - 0x1004]
            //   50                   | push                eax

        $sequence_15 = { 68???????? 50 ffd6 6a00 6a00 6a00 }
            // n = 6, score = 600
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_16 = { 8d442404 6a00 8bf1 50 c744240c00000000 ff15???????? }
            // n = 6, score = 600
            //   8d442404             | lea                 eax, [esp + 4]
            //   6a00                 | push                0
            //   8bf1                 | mov                 esi, ecx
            //   50                   | push                eax
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   ff15????????         |                     

        $sequence_17 = { 52 ff15???????? 8b0d???????? 8bf0 8b5c241c 8d041e }
            // n = 6, score = 500
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8b5c241c             | mov                 ebx, dword ptr [esp + 0x1c]
            //   8d041e               | lea                 eax, [esi + ebx]

        $sequence_18 = { 50 68???????? 68???????? 8985f0fdffff 8d85f4fdffff 6804010000 50 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   8985f0fdffff         | mov                 dword ptr [ebp - 0x210], eax
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   6804010000           | push                0x104
            //   50                   | push                eax

        $sequence_19 = { 03cf 880431 fec3 ebe6 }
            // n = 4, score = 500
            //   03cf                 | add                 ecx, edi
            //   880431               | mov                 byte ptr [ecx + esi], al
            //   fec3                 | inc                 bl
            //   ebe6                 | jmp                 0xffffffe8

        $sequence_20 = { 52 e8???????? 83c408 33c0 8b4df0 64890d00000000 }
            // n = 6, score = 500
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   33c0                 | xor                 eax, eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_21 = { 81e1ffff0000 81e1ffff0000 81e1ff000000 81e1ff000000 }
            // n = 4, score = 500
            //   81e1ffff0000         | and                 ecx, 0xffff
            //   81e1ffff0000         | and                 ecx, 0xffff
            //   81e1ff000000         | and                 ecx, 0xff
            //   81e1ff000000         | and                 ecx, 0xff

        $sequence_22 = { 5d 83c8ff 5b c20c00 03f7 }
            // n = 5, score = 500
            //   5d                   | pop                 ebp
            //   83c8ff               | or                  eax, 0xffffffff
            //   5b                   | pop                 ebx
            //   c20c00               | ret                 0xc
            //   03f7                 | add                 esi, edi

        $sequence_23 = { 8b8dd8edffff 51 8d95f4edffff 52 }
            // n = 4, score = 400
            //   8b8dd8edffff         | mov                 ecx, dword ptr [ebp - 0x1228]
            //   51                   | push                ecx
            //   8d95f4edffff         | lea                 edx, [ebp - 0x120c]
            //   52                   | push                edx

        $sequence_24 = { 81e2ffff0000 81e2ffff0000 c1ea08 81e2ff000000 }
            // n = 4, score = 400
            //   81e2ffff0000         | and                 edx, 0xffff
            //   81e2ffff0000         | and                 edx, 0xffff
            //   c1ea08               | shr                 edx, 8
            //   81e2ff000000         | and                 edx, 0xff

        $sequence_25 = { e8???????? 8be8 8b442410 50 e8???????? }
            // n = 5, score = 400
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_26 = { 6888130000 ff15???????? c745f000000000 c745f400000000 }
            // n = 4, score = 400
            //   6888130000           | push                0x1388
            //   ff15????????         |                     
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0

        $sequence_27 = { 25ffff0000 0fb7c8 c1e908 81e1ff000000 0fb6d1 52 }
            // n = 6, score = 400
            //   25ffff0000           | and                 eax, 0xffff
            //   0fb7c8               | movzx               ecx, ax
            //   c1e908               | shr                 ecx, 8
            //   81e1ff000000         | and                 ecx, 0xff
            //   0fb6d1               | movzx               edx, cl
            //   52                   | push                edx

        $sequence_28 = { ff15???????? 83c414 8d95f4fdffff 52 ff15???????? }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   83c414               | add                 esp, 0x14
            //   8d95f4fdffff         | lea                 edx, [ebp - 0x20c]
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_29 = { 56 51 56 6a01 }
            // n = 4, score = 400
            //   56                   | push                esi
            //   51                   | push                ecx
            //   56                   | push                esi
            //   6a01                 | push                1

        $sequence_30 = { ff15???????? ba00080000 2bd0 52 8d85fcefffff }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   ba00080000           | mov                 edx, 0x800
            //   2bd0                 | sub                 edx, eax
            //   52                   | push                edx
            //   8d85fcefffff         | lea                 eax, [ebp - 0x1004]

        $sequence_31 = { a1???????? 50 68???????? 8b0d???????? 51 ff15???????? ffd0 }
            // n = 7, score = 400
            //   a1????????           |                     
            //   50                   | push                eax
            //   68????????           |                     
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   ffd0                 | call                eax

        $sequence_32 = { 0305???????? 50 ff15???????? a1???????? }
            // n = 4, score = 300
            //   0305????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   a1????????           |                     

        $sequence_33 = { ffd6 ffd0 68???????? a3???????? }
            // n = 4, score = 300
            //   ffd6                 | call                esi
            //   ffd0                 | call                eax
            //   68????????           |                     
            //   a3????????           |                     

        $sequence_34 = { 68???????? 51 ffd3 ffd0 }
            // n = 4, score = 300
            //   68????????           |                     
            //   51                   | push                ecx
            //   ffd3                 | call                ebx
            //   ffd0                 | call                eax

        $sequence_35 = { 5f 5b 5d c3 b81c000000 e8???????? 89e0 }
            // n = 7, score = 200
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   b81c000000           | mov                 eax, 0x1c
            //   e8????????           |                     
            //   89e0                 | mov                 eax, esp

        $sequence_36 = { 29d6 0faff0 31d2 f7f6 }
            // n = 4, score = 200
            //   29d6                 | sub                 esi, edx
            //   0faff0               | imul                esi, eax
            //   31d2                 | xor                 edx, edx
            //   f7f6                 | div                 esi

        $sequence_37 = { 5f 5d c3 89e0 c70010270000 }
            // n = 5, score = 200
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   89e0                 | mov                 eax, esp
            //   c70010270000         | mov                 dword ptr [eax], 0x2710

        $sequence_38 = { 68???????? 53 a3???????? ffd6 68???????? a3???????? ffd7 }
            // n = 7, score = 200
            //   68????????           |                     
            //   53                   | push                ebx
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   a3????????           |                     
            //   ffd7                 | call                edi

        $sequence_39 = { 29d6 01f0 a3???????? e9???????? }
            // n = 4, score = 200
            //   29d6                 | sub                 esi, edx
            //   01f0                 | add                 eax, esi
            //   a3????????           |                     
            //   e9????????           |                     

        $sequence_40 = { 690006000000 0306 8b4dcc 8b09 }
            // n = 4, score = 200
            //   690006000000         | imul                eax, dword ptr [eax], 6
            //   0306                 | add                 eax, dword ptr [esi]
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   8b09                 | mov                 ecx, dword ptr [ecx]

        $sequence_41 = { a3???????? ffd7 8bd8 68???????? }
            // n = 4, score = 200
            //   a3????????           |                     
            //   ffd7                 | call                edi
            //   8bd8                 | mov                 ebx, eax
            //   68????????           |                     

        $sequence_42 = { bf04010000 57 6a08 ff35???????? ff15???????? }
            // n = 5, score = 200
            //   bf04010000           | mov                 edi, 0x104
            //   57                   | push                edi
            //   6a08                 | push                8
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_43 = { 6689fb 0fb7fb c1ef08 81e7ff000000 }
            // n = 4, score = 200
            //   6689fb               | mov                 bx, di
            //   0fb7fb               | movzx               edi, bx
            //   c1ef08               | shr                 edi, 8
            //   81e7ff000000         | and                 edi, 0xff

        $sequence_44 = { 8908 8b00 8b5004 8b35???????? }
            // n = 4, score = 200
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   8b35????????         |                     

        $sequence_45 = { 56 57 8b3d???????? 68???????? ffd7 8b35???????? 68???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   8b35????????         |                     
            //   68????????           |                     

        $sequence_46 = { 8908 8b15???????? 89d6 81c609000000 }
            // n = 4, score = 200
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b15????????         |                     
            //   89d6                 | mov                 esi, edx
            //   81c609000000         | add                 esi, 9

    condition:
        7 of them and filesize < 303100
}