rule win_coronavirus_ransomware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.coronavirus_ransomware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.coronavirus_ransomware"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7dbc 2bfb 1bc6 8945d0 8b4dc8 8d140b }
            // n = 6, score = 100
            //   8b7dbc               | mov                 edi, dword ptr [ebp - 0x44]
            //   2bfb                 | sub                 edi, ebx
            //   1bc6                 | sbb                 eax, esi
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   8d140b               | lea                 edx, [ebx + ecx]

        $sequence_1 = { 83c404 85f6 746a 803e00 7465 33c0 33d2 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   746a                 | je                  0x6c
            //   803e00               | cmp                 byte ptr [esi], 0
            //   7465                 | je                  0x67
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx

        $sequence_2 = { 8b35???????? 83c404 85f6 746a 803e00 }
            // n = 5, score = 100
            //   8b35????????         |                     
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   746a                 | je                  0x6c
            //   803e00               | cmp                 byte ptr [esi], 0

        $sequence_3 = { 90 8b55ec 8b45f0 6a00 b9???????? 81e9???????? }
            // n = 6, score = 100
            //   90                   | nop                 
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   6a00                 | push                0
            //   b9????????           |                     
            //   81e9????????         |                     

        $sequence_4 = { e8???????? 83c404 6a00 6a00 0fb60d???????? 8b148d78954100 52 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   0fb60d????????       |                     
            //   8b148d78954100       | mov                 edx, dword ptr [ecx*4 + 0x419578]
            //   52                   | push                edx

        $sequence_5 = { 33f6 56 56 6a03 56 6a03 56 }
            // n = 7, score = 100
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi
            //   56                   | push                esi
            //   6a03                 | push                3
            //   56                   | push                esi
            //   6a03                 | push                3
            //   56                   | push                esi

        $sequence_6 = { ffd0 6800200000 8d85f8deffff 50 ff15???????? }
            // n = 5, score = 100
            //   ffd0                 | call                eax
            //   6800200000           | push                0x2000
            //   8d85f8deffff         | lea                 eax, [ebp - 0x2108]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { 85db 0f84cd010000 c745fc01000000 8975e4 }
            // n = 4, score = 100
            //   85db                 | test                ebx, ebx
            //   0f84cd010000         | je                  0x1d3
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi

        $sequence_8 = { b8???????? e8???????? 8d4df0 51 8d55a0 52 }
            // n = 6, score = 100
            //   b8????????           |                     
            //   e8????????           |                     
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   51                   | push                ecx
            //   8d55a0               | lea                 edx, [ebp - 0x60]
            //   52                   | push                edx

        $sequence_9 = { ff15???????? 8b35???????? 83c418 68???????? ffd6 68???????? ffd6 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   83c418               | add                 esp, 0x18
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   ffd6                 | call                esi

    condition:
        7 of them and filesize < 235520
}