rule win_cotx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cotx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cotx"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c 8d45e0 50 ff15???????? 0fb745ee }
            // n = 5, score = 500
            //   83c40c               | add                 esp, 0xc
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   0fb745ee             | movzx               eax, word ptr [ebp - 0x12]

        $sequence_1 = { c705????????69e053a4 c705????????120d934e c705????????b0b65443 c705????????4df9e511 c705????????0e9a3f4b }
            // n = 5, score = 500
            //   c705????????69e053a4     |     
            //   c705????????120d934e     |     
            //   c705????????b0b65443     |     
            //   c705????????4df9e511     |     
            //   c705????????0e9a3f4b     |     

        $sequence_2 = { 83e103 f3a4 8dbd98faffff 4f }
            // n = 4, score = 500
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8dbd98faffff         | lea                 edi, [ebp - 0x568]
            //   4f                   | dec                 edi

        $sequence_3 = { c705????????9cb95b4c c705????????2d494a94 c705????????8db133d4 c705????????8e220b1d c705????????6825794d c705????????4506ce62 }
            // n = 6, score = 500
            //   c705????????9cb95b4c     |     
            //   c705????????2d494a94     |     
            //   c705????????8db133d4     |     
            //   c705????????8e220b1d     |     
            //   c705????????6825794d     |     
            //   c705????????4506ce62     |     

        $sequence_4 = { 8d85bcf3ffff 50 ff15???????? 8bf0 }
            // n = 4, score = 500
            //   8d85bcf3ffff         | lea                 eax, [ebp - 0xc44]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { c705????????f0e91f15 c705????????9cb95b4c c705????????2d494a94 c705????????8db133d4 c705????????8e220b1d }
            // n = 5, score = 500
            //   c705????????f0e91f15     |     
            //   c705????????9cb95b4c     |     
            //   c705????????2d494a94     |     
            //   c705????????8db133d4     |     
            //   c705????????8e220b1d     |     

        $sequence_6 = { 68???????? 56 e8???????? 6800f00000 81c690ef0000 68???????? }
            // n = 6, score = 500
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   6800f00000           | push                0xf000
            //   81c690ef0000         | add                 esi, 0xef90
            //   68????????           |                     

        $sequence_7 = { c785b8faffff39313044 c1e902 f3a5 8bca }
            // n = 4, score = 500
            //   c785b8faffff39313044     | mov    dword ptr [ebp - 0x548], 0x44303139
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bca                 | mov                 ecx, edx

        $sequence_8 = { 6800040000 8d8598f6ffff 6a00 50 e8???????? 83c40c 8d8598feffff }
            // n = 7, score = 500
            //   6800040000           | push                0x400
            //   8d8598f6ffff         | lea                 eax, [ebp - 0x968]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d8598feffff         | lea                 eax, [ebp - 0x168]

        $sequence_9 = { e8???????? 6890ef0000 8d7760 68???????? }
            // n = 4, score = 500
            //   e8????????           |                     
            //   6890ef0000           | push                0xef90
            //   8d7760               | lea                 esi, [edi + 0x60]
            //   68????????           |                     

    condition:
        7 of them and filesize < 1171456
}