rule win_cova_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cova."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cova"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 813bc8000000 7577 488d4d88 ff9598000000 488d4d80 8bf0 b81f85eb51 }
            // n = 7, score = 100
            //   813bc8000000         | add                 eax, edi
            //   7577                 | dec                 eax
            //   488d4d88             | mov                 dword ptr [ebp - 0x60], eax
            //   ff9598000000         | dec                 eax
            //   488d4d80             | add                 eax, edi
            //   8bf0                 | dec                 eax
            //   b81f85eb51           | mov                 dword ptr [ebp - 0x60], eax

        $sequence_1 = { 4c8d8d70120000 4c8d8560010000 4889542430 488d95e0000000 }
            // n = 4, score = 100
            //   4c8d8d70120000       | mov                 dword ptr [esp + 0x20], eax
            //   4c8d8560010000       | dec                 esp
            //   4889542430           | mov                 ecx, dword ptr [esp + 0x50]
            //   488d95e0000000       | dec                 esp

        $sequence_2 = { 488d442440 4889442428 488d0518a30000 4889442420 4c8b4c2450 4c8b442458 }
            // n = 6, score = 100
            //   488d442440           | mov                 dword ptr [esp + 0x48], eax
            //   4889442428           | mov                 dword ptr [esp + 0x20], esi
            //   488d0518a30000       | call                dword ptr [ebp + 0x10]
            //   4889442420           | dec                 esp
            //   4c8b4c2450           | mov                 esp, eax
            //   4c8b442458           | xor                 ecx, ecx

        $sequence_3 = { 488d8d00150000 ff55b0 448d4e08 4c8d442470 8d1400 488d8d00150000 ff5550 }
            // n = 7, score = 100
            //   488d8d00150000       | lea                 ecx, [ebp + 0x2e0]
            //   ff55b0               | dec                 eax
            //   448d4e08             | lea                 edx, [ebp + 0x150]
            //   4c8d442470           | inc                 ebp
            //   8d1400               | xor                 eax, eax
            //   488d8d00150000       | xor                 ecx, ecx
            //   ff5550               | call                dword ptr [ebp + 0xb0]

        $sequence_4 = { 41b806000000 488d158e680000 483950f0 740c 488b10 4885d2 }
            // n = 6, score = 100
            //   41b806000000         | lea                 edx, [ebp + 0x750]
            //   488d158e680000       | dec                 esp
            //   483950f0             | mov                 eax, esi
            //   740c                 | dec                 eax
            //   488b10               | mov                 ecx, edi
            //   4885d2               | test                al, al

        $sequence_5 = { 33d2 33c9 ff5778 488bd8 4885c0 741f ba20bf0200 }
            // n = 7, score = 100
            //   33d2                 | inc                 esp
            //   33c9                 | mov                 edi, esi
            //   ff5778               | dec                 eax
            //   488bd8               | cmp                 dword ptr [esp + 0x50], esi
            //   4885c0               | je                  0x1210
            //   741f                 | call                dword ptr [ebp]
            //   ba20bf0200           | dec                 esp

        $sequence_6 = { 57 4883ec20 488d1ddf5e0000 bf0a000000 }
            // n = 4, score = 100
            //   57                   | je                  0x604
            //   4883ec20             | dec                 eax
            //   488d1ddf5e0000       | lea                 ecx, [edi + eax]
            //   bf0a000000           | mov                 eax, dword ptr [ecx + edx*4]

        $sequence_7 = { 7d08 8d4a30 418808 eb06 }
            // n = 4, score = 100
            //   7d08                 | call                dword ptr [edi + 0xb0]
            //   8d4a30               | dec                 eax
            //   418808               | lea                 ecx, [esp + 0x44]
            //   eb06                 | call                dword ptr [ebp + 0x98]

        $sequence_8 = { 4885c9 741c f0ff09 7517 488d05bf830000 }
            // n = 5, score = 100
            //   4885c9               | inc                 ecx
            //   741c                 | mov                 byte ptr [eax], al
            //   f0ff09               | inc                 edx
            //   7517                 | dec                 ecx
            //   488d05bf830000       | inc                 eax

        $sequence_9 = { ba20bf0200 488bc8 ff5720 3d80000000 742a }
            // n = 5, score = 100
            //   ba20bf0200           | lea                 eax, [ebx + 2]
            //   488bc8               | dec                 eax
            //   ff5720               | lea                 edx, [esp + 0x30]
            //   3d80000000           | call                dword ptr [edi + 0x100]
            //   742a                 | dec                 esp

    condition:
        7 of them and filesize < 123904
}