rule win_crackedcantil_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crackedcantil."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crackedcantil"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffc8 89442420 837c242400 7e45 488b442428 4883780800 7429 }
            // n = 7, score = 100
            //   ffc8                 | push                esp
            //   89442420             | inc                 ecx
            //   837c242400           | pop                 edi
            //   7e45                 | dec                 ecx
            //   488b442428           | add                 edi, 8
            //   4883780800           | dec                 ecx
            //   7429                 | add                 edi, 8

        $sequence_1 = { e8???????? 90 488d8c24e06f0000 e8???????? 488d842483000000 488bf8 33c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [esp + 0x31d8], eax
            //   488d8c24e06f0000     | dec                 eax
            //   e8????????           |                     
            //   488d842483000000     | mov                 eax, dword ptr [esp + 0x31d8]
            //   488bf8               | dec                 esp
            //   33c0                 | lea                 ecx, [0x15263b]

        $sequence_2 = { f7d9 81e9b2638081 29cb 59 81c3e75cef77 81ebcdbddaf2 01d8 }
            // n = 7, score = 100
            //   f7d9                 | dec                 esi
            //   81e9b2638081         | not                 dl
            //   29cb                 | sub                 dl, 0x34
            //   59                   | not                 dl
            //   81c3e75cef77         | ror                 dword ptr [esp + 1], 0xbc
            //   81ebcdbddaf2         | jae                 0xffff9564
            //   01d8                 | dec                 eax

        $sequence_3 = { ffc9 8bc9 488b542478 88040a 488b542438 488b4c2478 e8???????? }
            // n = 7, score = 100
            //   ffc9                 | add                 ebp, 8
            //   8bc9                 | push                dword ptr [esp + 0x20]
            //   488b542478           | push                dword ptr [esp]
            //   88040a               | pop                 eax
            //   488b542438           | push                esi
            //   488b4c2478           | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { f3aa 0fb684248e000000 88842490040000 660f6f842490570000 660f7f842470350000 488b8424c80f0000 f30f6f00 }
            // n = 7, score = 100
            //   f3aa                 | dec                 esp
            //   0fb684248e000000     | mov                 dword ptr [esp], ebp
            //   88842490040000       | dec                 ebp
            //   660f6f842490570000     | mov    ebp, ebp
            //   660f7f842470350000     | dec    eax
            //   488b8424c80f0000     | sub                 esp, 8
            //   f30f6f00             | pop                 esi

        $sequence_5 = { e8???????? 90 488d842470030000 4889842478030000 488b942478030000 488d0de1993000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488d842470030000     | mov                 edx, dword ptr [esp + 0xf8]
            //   4889842478030000     | dec                 eax
            //   488b942478030000     | mov                 ecx, dword ptr [esp + 0x100]
            //   488d0de1993000       | nop                 
            //   e8????????           |                     

        $sequence_6 = { e8???????? 488bc8 e8???????? 488bc8 e8???????? 898424301c0000 ba08000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bc8               | dec                 eax
            //   e8????????           |                     
            //   488bc8               | mov                 dword ptr [esp + 8], esi
            //   e8????????           |                     
            //   898424301c0000       | dec                 eax
            //   ba08000000           | mov                 esi, dword ptr [esp]

        $sequence_7 = { f3aa 488d8424b8020000 488bf8 33c0 b901000000 f3aa 488d8424b9020000 }
            // n = 7, score = 100
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   488d8424b8020000     | movzx               eax, byte ptr [esp + 0x39a]
            //   488bf8               | rep stosb           byte ptr es:[edi], al
            //   33c0                 | dec                 eax
            //   b901000000           | lea                 eax, [esp + 0x39c]
            //   f3aa                 | dec                 eax
            //   488d8424b9020000     | mov                 edi, eax

        $sequence_8 = { ffc0 89442430 488b442478 0fb74060 ffc8 39442430 7d3d }
            // n = 7, score = 100
            //   ffc0                 | pop                 dword ptr [esp]
            //   89442430             | push                0x7a9ff0bd
            //   488b442478           | push                dword ptr [esp + 8]
            //   0fb74060             | inc                 ecx
            //   ffc8                 | pop                 ebp
            //   39442430             | pop                 dword ptr [esp]
            //   7d3d                 | dec                 eax

        $sequence_9 = { e9???????? 9c 4156 4883ec08 4c893424 ff3424 415e }
            // n = 7, score = 100
            //   e9????????           |                     
            //   9c                   | inc                 ecx
            //   4156                 | and                 edx, 0x6c3c7540
            //   4883ec08             | push                ebx
            //   4c893424             | mov                 ebx, 0x73ff77c4
            //   ff3424               | neg                 ebx
            //   415e                 | sub                 ebx, 0x1c82f177

    condition:
        7 of them and filesize < 37863424
}