rule win_crat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 488bd0 488d8d78010000 e8???????? 90 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   488bd0               | lea                 ecx, [ebp + 0xb8]
            //   488d8d78010000       | nop                 
            //   e8????????           |                     
            //   90                   | dec                 eax

        $sequence_1 = { 488bd0 488d8d38030000 e8???????? 90 }
            // n = 4, score = 500
            //   488bd0               | lea                 ecx, [ebp + 0xe8]
            //   488d8d38030000       | nop                 
            //   e8????????           |                     
            //   90                   | dec                 eax

        $sequence_2 = { e8???????? 488bd0 488d8d28010000 e8???????? 90 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   488bd0               | dec                 eax
            //   488d8d28010000       | mov                 edx, eax
            //   e8????????           |                     
            //   90                   | dec                 eax

        $sequence_3 = { e8???????? 488bd0 488d4d90 e8???????? 90 488bd0 }
            // n = 6, score = 500
            //   e8????????           |                     
            //   488bd0               | nop                 
            //   488d4d90             | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 edx, eax
            //   488bd0               | dec                 eax

        $sequence_4 = { e8???????? 488bd0 488d8db8000000 e8???????? 90 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   488bd0               | mov                 edx, eax
            //   488d8db8000000       | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 ecx, [ebp + 0x128]

        $sequence_5 = { e8???????? 488bd0 488d8d40010000 e8???????? 90 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   488bd0               | jmp                 0xffffffd2
            //   488d8d40010000       | dec                 ecx
            //   e8????????           |                     
            //   90                   | mov                 eax, esp

        $sequence_6 = { e8???????? 488bd0 488d8de8000000 e8???????? 90 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   488bd0               | lea                 ecx, [ebp + 0x140]
            //   488d8de8000000       | nop                 
            //   e8????????           |                     
            //   90                   | dec                 eax

        $sequence_7 = { ebd0 498bc4 48833d????????10 480f4305???????? 482bc8 }
            // n = 5, score = 500
            //   ebd0                 | jmp                 0xffffffd2
            //   498bc4               | dec                 ecx
            //   48833d????????10     |                     
            //   480f4305????????     |                     
            //   482bc8               | mov                 eax, esp

        $sequence_8 = { 33d2 c1e902 f7f1 eb02 }
            // n = 4, score = 300
            //   33d2                 | dec                 eax
            //   c1e902               | mov                 edx, eax
            //   f7f1                 | dec                 eax
            //   eb02                 | lea                 ecx, [ebp + 0x178]

        $sequence_9 = { ffd0 85c0 750f ff15???????? 83f87a }
            // n = 5, score = 300
            //   ffd0                 | lea                 ecx, [esi + 0x18]
            //   85c0                 | sub                 eax, dword ptr [esi + 0x24]
            //   750f                 | cmp                 eax, 0x10
            //   ff15????????         |                     
            //   83f87a               | jge                 0xe

        $sequence_10 = { 52 8b01 ff5004 c645fc08 8bcf 8b5648 }
            // n = 6, score = 200
            //   52                   | mov                 ecx, edi
            //   8b01                 | mov                 edx, dword ptr [esi + 0x40]
            //   ff5004               | sub                 edx, 0x10
            //   c645fc08             | sub                 eax, dword ptr [esi + 0xc]
            //   8bcf                 | movsd               qword ptr [ebp - 0x40], xmm1
            //   8b5648               | cmp                 eax, 0x10

        $sequence_11 = { 2b460c f20f114dc0 83f810 7d0d 51 }
            // n = 5, score = 200
            //   2b460c               | div                 ecx
            //   f20f114dc0           | jmp                 4
            //   83f810               | xor                 edx, edx
            //   7d0d                 | mov                 ecx, edx
            //   51                   | xor                 edx, edx

        $sequence_12 = { 50 e8???????? 83c404 e8???????? 33d2 f7f7 81c2e8030000 }
            // n = 7, score = 200
            //   50                   | cmp                 eax, 0x10
            //   e8????????           |                     
            //   83c404               | jge                 0x12
            //   e8????????           |                     
            //   33d2                 | push                ecx
            //   f7f7                 | mov                 ecx, esi
            //   81c2e8030000         | push                edx

        $sequence_13 = { 52 8b01 ff5004 c645fc07 8bcf 8b5640 }
            // n = 6, score = 200
            //   52                   | call                dword ptr [eax + 4]
            //   8b01                 | mov                 byte ptr [ebp - 4], 6
            //   ff5004               | mov                 ecx, edi
            //   c645fc07             | mov                 edx, dword ptr [esi + 0x3c]
            //   8bcf                 | sub                 edx, 0x10
            //   8b5640               | cmp                 byte ptr [ebp - 0x1d], dl

        $sequence_14 = { 52 8b01 ff5004 c645fc06 8bcf 8b563c 83ea10 }
            // n = 7, score = 200
            //   52                   | xor                 edx, edx
            //   8b01                 | shr                 ecx, 2
            //   ff5004               | div                 ecx
            //   c645fc06             | jmp                 9
            //   8bcf                 | mov                 ecx, edx
            //   8b563c               | xor                 edx, edx
            //   83ea10               | shr                 ecx, 2

        $sequence_15 = { 2b4624 83f810 7d09 51 }
            // n = 4, score = 200
            //   2b4624               | mov                 eax, dword ptr [ecx]
            //   83f810               | call                dword ptr [eax + 4]
            //   7d09                 | mov                 byte ptr [ebp - 4], 7
            //   51                   | mov                 ecx, edi

        $sequence_16 = { 3855e3 7408 8b4dd8 8b55dc eb04 8bce 33d2 }
            // n = 7, score = 200
            //   3855e3               | div                 ecx
            //   7408                 | mov                 ecx, edx
            //   8b4dd8               | xor                 edx, edx
            //   8b55dc               | shr                 ecx, 2
            //   eb04                 | div                 ecx
            //   8bce                 | jmp                 9
            //   33d2                 | shr                 ecx, 2

    condition:
        7 of them and filesize < 4161536
}