rule win_credraptor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.credraptor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.credraptor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4720 83c40c 837e4000 89558c 8945c0 894db8 0f85c9120000 }
            // n = 7, score = 100
            //   8b4720               | mov                 eax, dword ptr [edi + 0x20]
            //   83c40c               | add                 esp, 0xc
            //   837e4000             | cmp                 dword ptr [esi + 0x40], 0
            //   89558c               | mov                 dword ptr [ebp - 0x74], edx
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   894db8               | mov                 dword ptr [ebp - 0x48], ecx
            //   0f85c9120000         | jne                 0x12cf

        $sequence_1 = { e8???????? 83c40c e9???????? 837f3000 7415 8b5508 52 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   e9????????           |                     
            //   837f3000             | cmp                 dword ptr [edi + 0x30], 0
            //   7415                 | je                  0x17
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx

        $sequence_2 = { e8???????? 83c404 8b5dfc 5e 8b4d0c 51 8bc3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   5e                   | pop                 esi
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   8bc3                 | mov                 eax, ebx

        $sequence_3 = { e9???????? a802 7508 83c8ff e9???????? 8b45f0 85c0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   a802                 | test                al, 2
            //   7508                 | jne                 0xa
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   85c0                 | test                eax, eax

        $sequence_4 = { c6043b25 03da ddd9 ddd8 8b4d94 41 803900 }
            // n = 7, score = 100
            //   c6043b25             | mov                 byte ptr [ebx + edi], 0x25
            //   03da                 | add                 ebx, edx
            //   ddd9                 | fstp                st(1)
            //   ddd8                 | fstp                st(0)
            //   8b4d94               | mov                 ecx, dword ptr [ebp - 0x6c]
            //   41                   | inc                 ecx
            //   803900               | cmp                 byte ptr [ecx], 0

        $sequence_5 = { c745dc377f0682 c745e0002de218 884de9 8855ea 8845eb 3bc7 750e }
            // n = 7, score = 100
            //   c745dc377f0682       | mov                 dword ptr [ebp - 0x24], 0x82067f37
            //   c745e0002de218       | mov                 dword ptr [ebp - 0x20], 0x18e22d00
            //   884de9               | mov                 byte ptr [ebp - 0x17], cl
            //   8855ea               | mov                 byte ptr [ebp - 0x16], dl
            //   8845eb               | mov                 byte ptr [ebp - 0x15], al
            //   3bc7                 | cmp                 eax, edi
            //   750e                 | jne                 0x10

        $sequence_6 = { c70353000000 b802000000 5b 5d c3 83f83e 7510 }
            // n = 7, score = 100
            //   c70353000000         | mov                 dword ptr [ebx], 0x53
            //   b802000000           | mov                 eax, 2
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   83f83e               | cmp                 eax, 0x3e
            //   7510                 | jne                 0x12

        $sequence_7 = { be???????? 8d4ddc 8a01 3a06 751a 84c0 7412 }
            // n = 7, score = 100
            //   be????????           |                     
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   3a06                 | cmp                 al, byte ptr [esi]
            //   751a                 | jne                 0x1c
            //   84c0                 | test                al, al
            //   7412                 | je                  0x14

        $sequence_8 = { c1f812 0cf0 0fb6c8 51 8bce e8???????? 8bd3 }
            // n = 7, score = 100
            //   c1f812               | sar                 eax, 0x12
            //   0cf0                 | or                  al, 0xf0
            //   0fb6c8               | movzx               ecx, al
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bd3                 | mov                 edx, ebx

        $sequence_9 = { e8???????? ff45e4 83c404 83c318 8945f0 85c0 74e0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ff45e4               | inc                 dword ptr [ebp - 0x1c]
            //   83c404               | add                 esp, 4
            //   83c318               | add                 ebx, 0x18
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   85c0                 | test                eax, eax
            //   74e0                 | je                  0xffffffe2

    condition:
        7 of them and filesize < 1728512
}