rule win_cruloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cruloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cruloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 56 57 8b7d08 eb6f 8b07 8d1c85605c4100 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   eb6f                 | jmp                 0x71
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8d1c85605c4100       | lea                 ebx, [eax*4 + 0x415c60]

        $sequence_1 = { 8b413c 0f104508 53 56 }
            // n = 4, score = 100
            //   8b413c               | mov                 eax, dword ptr [ecx + 0x3c]
            //   0f104508             | movups              xmm0, xmmword ptr [ebp + 8]
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_2 = { 8bcf 83e73f c1f906 6bd738 8b0c8dd85e4100 c644112800 85f6 }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   83e73f               | and                 edi, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bd738               | imul                edx, edi, 0x38
            //   8b0c8dd85e4100       | mov                 ecx, dword ptr [ecx*4 + 0x415ed8]
            //   c644112800           | mov                 byte ptr [ecx + edx + 0x28], 0
            //   85f6                 | test                esi, esi

        $sequence_3 = { 6bc618 57 8db8e8604100 57 ff15???????? }
            // n = 5, score = 100
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8e8604100         | lea                 edi, [eax + 0x4160e8]
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_4 = { c0c104 80f19a 884c15f0 42 3bd0 }
            // n = 5, score = 100
            //   c0c104               | rol                 cl, 4
            //   80f19a               | xor                 cl, 0x9a
            //   884c15f0             | mov                 byte ptr [ebp + edx - 0x10], cl
            //   42                   | inc                 edx
            //   3bd0                 | cmp                 edx, eax

        $sequence_5 = { 8b75e4 3bf7 7523 baf63f4890 b901000000 }
            // n = 5, score = 100
            //   8b75e4               | mov                 esi, dword ptr [ebp - 0x1c]
            //   3bf7                 | cmp                 esi, edi
            //   7523                 | jne                 0x25
            //   baf63f4890           | mov                 edx, 0x90483ff6
            //   b901000000           | mov                 ecx, 1

        $sequence_6 = { 33f6 898de0fcffff 898500fdffff 85db }
            // n = 4, score = 100
            //   33f6                 | xor                 esi, esi
            //   898de0fcffff         | mov                 dword ptr [ebp - 0x320], ecx
            //   898500fdffff         | mov                 dword ptr [ebp - 0x300], eax
            //   85db                 | test                ebx, ebx

        $sequence_7 = { 894de0 8b049dd85e4100 f644082801 7469 }
            // n = 4, score = 100
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b049dd85e4100       | mov                 eax, dword ptr [ebx*4 + 0x415ed8]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7469                 | je                  0x6b

        $sequence_8 = { 8b8514fdffff 898d0cfdffff 0fb74006 898508fdffff 85c0 7433 83c108 }
            // n = 7, score = 100
            //   8b8514fdffff         | mov                 eax, dword ptr [ebp - 0x2ec]
            //   898d0cfdffff         | mov                 dword ptr [ebp - 0x2f4], ecx
            //   0fb74006             | movzx               eax, word ptr [eax + 6]
            //   898508fdffff         | mov                 dword ptr [ebp - 0x2f8], eax
            //   85c0                 | test                eax, eax
            //   7433                 | je                  0x35
            //   83c108               | add                 ecx, 8

        $sequence_9 = { b902000000 e8???????? ba241d19e5 a3???????? }
            // n = 4, score = 100
            //   b902000000           | mov                 ecx, 2
            //   e8????????           |                     
            //   ba241d19e5           | mov                 edx, 0xe5191d24
            //   a3????????           |                     

    condition:
        7 of them and filesize < 196608
}