rule win_crypmic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crypmic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crypmic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 8bec 83ec10 837d0800 8bc2 894df8 0f868c000000 }
            // n = 7, score = 300
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   8bc2                 | mov                 eax, edx
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   0f868c000000         | jbe                 0x92

        $sequence_1 = { 740a 8d4002 46 66833800 75f6 8d3c72 33c0 }
            // n = 7, score = 300
            //   740a                 | je                  0xc
            //   8d4002               | lea                 eax, [eax + 2]
            //   46                   | inc                 esi
            //   66833800             | cmp                 word ptr [eax], 0
            //   75f6                 | jne                 0xfffffff8
            //   8d3c72               | lea                 edi, [edx + esi*2]
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 8d3409 33db 0fb7143e 663bda }
            // n = 4, score = 300
            //   8d3409               | lea                 esi, [ecx + ecx]
            //   33db                 | xor                 ebx, ebx
            //   0fb7143e             | movzx               edx, word ptr [esi + edi]
            //   663bda               | cmp                 bx, dx

        $sequence_3 = { 66833800 75f6 8d3c72 33c0 }
            // n = 4, score = 300
            //   66833800             | cmp                 word ptr [eax], 0
            //   75f6                 | jne                 0xfffffff8
            //   8d3c72               | lea                 edi, [edx + esi*2]
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 0fb78c15c0fdffff 663bf1 75e8 8b75f4 }
            // n = 4, score = 300
            //   0fb78c15c0fdffff     | movzx               ecx, word ptr [ebp + edx - 0x240]
            //   663bf1               | cmp                 si, cx
            //   75e8                 | jne                 0xffffffea
            //   8b75f4               | mov                 esi, dword ptr [ebp - 0xc]

        $sequence_5 = { 8b4e08 53 6a08 ff7604 }
            // n = 4, score = 300
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   53                   | push                ebx
            //   6a08                 | push                8
            //   ff7604               | push                dword ptr [esi + 4]

        $sequence_6 = { 8bec 81ec70020000 8b4108 53 56 }
            // n = 5, score = 300
            //   8bec                 | mov                 ebp, esp
            //   81ec70020000         | sub                 esp, 0x270
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_7 = { 56 57 894df4 83f828 7252 83e828 }
            // n = 6, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   83f828               | cmp                 eax, 0x28
            //   7252                 | jb                  0x54
            //   83e828               | sub                 eax, 0x28

        $sequence_8 = { 50 8b4608 6a08 ff7604 ffd0 8bf8 c70728000000 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   6a08                 | push                8
            //   ff7604               | push                dword ptr [esi + 4]
            //   ffd0                 | call                eax
            //   8bf8                 | mov                 edi, eax
            //   c70728000000         | mov                 dword ptr [edi], 0x28

        $sequence_9 = { bb04000000 eb27 83f808 7707 }
            // n = 4, score = 300
            //   bb04000000           | mov                 ebx, 4
            //   eb27                 | jmp                 0x29
            //   83f808               | cmp                 eax, 8
            //   7707                 | ja                  9

    condition:
        7 of them and filesize < 81920
}