rule win_crypt0l0cker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crypt0l0cker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crypt0l0cker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcb e8???????? eb05 bf03000000 56 6a01 682f5b5412 }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   eb05                 | jmp                 7
            //   bf03000000           | mov                 edi, 3
            //   56                   | push                esi
            //   6a01                 | push                1
            //   682f5b5412           | push                0x12545b2f

        $sequence_1 = { 53 e8???????? 59 59 85c0 0f84bbfeffff 8b45f8 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   0f84bbfeffff         | je                  0xfffffec1
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_2 = { 8bcf e8???????? 8b4c2418 e8???????? 85f6 740f 56 }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   e8????????           |                     
            //   85f6                 | test                esi, esi
            //   740f                 | je                  0x11
            //   56                   | push                esi

        $sequence_3 = { 0f8e85000000 53 ff75fc 8d45a8 50 8bd0 8d4dbc }
            // n = 7, score = 100
            //   0f8e85000000         | jle                 0x8b
            //   53                   | push                ebx
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   50                   | push                eax
            //   8bd0                 | mov                 edx, eax
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]

        $sequence_4 = { 33c1 894ee8 8946ec 8d042e c1f802 8b4c8314 8bc1 }
            // n = 7, score = 100
            //   33c1                 | xor                 eax, ecx
            //   894ee8               | mov                 dword ptr [esi - 0x18], ecx
            //   8946ec               | mov                 dword ptr [esi - 0x14], eax
            //   8d042e               | lea                 eax, [esi + ebp]
            //   c1f802               | sar                 eax, 2
            //   8b4c8314             | mov                 ecx, dword ptr [ebx + eax*4 + 0x14]
            //   8bc1                 | mov                 eax, ecx

        $sequence_5 = { 68???????? bac8cfa6d0 8bce e8???????? 83c404 85c0 0f85b2000000 }
            // n = 7, score = 100
            //   68????????           |                     
            //   bac8cfa6d0           | mov                 edx, 0xd0a6cfc8
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f85b2000000         | jne                 0xb8

        $sequence_6 = { e8???????? 83c40c 68fd010000 53 85f6 7506 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68fd010000           | push                0x1fd
            //   53                   | push                ebx
            //   85f6                 | test                esi, esi
            //   7506                 | jne                 8

        $sequence_7 = { 3bf2 7301 47 03d8 895de8 3bd8 }
            // n = 6, score = 100
            //   3bf2                 | cmp                 esi, edx
            //   7301                 | jae                 3
            //   47                   | inc                 edi
            //   03d8                 | add                 ebx, eax
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   3bd8                 | cmp                 ebx, eax

        $sequence_8 = { 8be5 5d c3 55 8bec 83ec18 8bc2 }
            // n = 7, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec18               | sub                 esp, 0x18
            //   8bc2                 | mov                 eax, edx

        $sequence_9 = { 0f8520080000 c74424143c000000 55 8d4900 837e3400 0f8505080000 833e01 }
            // n = 7, score = 100
            //   0f8520080000         | jne                 0x826
            //   c74424143c000000     | mov                 dword ptr [esp + 0x14], 0x3c
            //   55                   | push                ebp
            //   8d4900               | lea                 ecx, [ecx]
            //   837e3400             | cmp                 dword ptr [esi + 0x34], 0
            //   0f8505080000         | jne                 0x80b
            //   833e01               | cmp                 dword ptr [esi], 1

    condition:
        7 of them and filesize < 917504
}