rule win_cryptbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cryptbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 85ed 0f94c0 8be8 }
            // n = 4, score = 700
            //   33c0                 | xor                 eax, eax
            //   85ed                 | test                ebp, ebp
            //   0f94c0               | sete                al
            //   8be8                 | mov                 ebp, eax

        $sequence_1 = { 760f b990ec0000 e8???????? e9???????? }
            // n = 4, score = 600
            //   760f                 | jbe                 0x11
            //   b990ec0000           | mov                 ecx, 0xec90
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_2 = { e9???????? b949dc0000 e9???????? b944dc0000 e9???????? b964dc0000 }
            // n = 6, score = 600
            //   e9????????           |                     
            //   b949dc0000           | mov                 ecx, 0xdc49
            //   e9????????           |                     
            //   b944dc0000           | mov                 ecx, 0xdc44
            //   e9????????           |                     
            //   b964dc0000           | mov                 ecx, 0xdc64

        $sequence_3 = { 7f0a 83fd1e 7f05 83ff13 }
            // n = 4, score = 600
            //   7f0a                 | jg                  0xc
            //   83fd1e               | cmp                 ebp, 0x1e
            //   7f05                 | jg                  7
            //   83ff13               | cmp                 edi, 0x13

        $sequence_4 = { eb0c b99fed0000 e8???????? 8907 }
            // n = 4, score = 600
            //   eb0c                 | jmp                 0xe
            //   b99fed0000           | mov                 ecx, 0xed9f
            //   e8????????           |                     
            //   8907                 | mov                 dword ptr [edi], eax

        $sequence_5 = { 33c0 eb0a b917d90000 e8???????? }
            // n = 4, score = 600
            //   33c0                 | xor                 eax, eax
            //   eb0a                 | jmp                 0xc
            //   b917d90000           | mov                 ecx, 0xd917
            //   e8????????           |                     

        $sequence_6 = { 7511 b9d7d80000 e8???????? 8907 }
            // n = 4, score = 600
            //   7511                 | jne                 0x13
            //   b9d7d80000           | mov                 ecx, 0xd8d7
            //   e8????????           |                     
            //   8907                 | mov                 dword ptr [edi], eax

        $sequence_7 = { 750f b955960100 e8???????? e9???????? }
            // n = 4, score = 600
            //   750f                 | jne                 0x11
            //   b955960100           | mov                 ecx, 0x19655
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_8 = { 7414 3c7a 7508 8b4610 803874 7408 41 }
            // n = 7, score = 400
            //   7414                 | je                  0x16
            //   3c7a                 | cmp                 al, 0x7a
            //   7508                 | jne                 0xa
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   803874               | cmp                 byte ptr [eax], 0x74
            //   7408                 | je                  0xa
            //   41                   | inc                 ecx

        $sequence_9 = { 83caff 8bcf e8???????? 83caff }
            // n = 4, score = 400
            //   83caff               | or                  edx, 0xffffffff
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   83caff               | or                  edx, 0xffffffff

        $sequence_10 = { 7419 8b542408 83fa01 7c10 0fbf4846 }
            // n = 5, score = 400
            //   7419                 | je                  0x1b
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   83fa01               | cmp                 edx, 1
            //   7c10                 | jl                  0x12
            //   0fbf4846             | movsx               ecx, word ptr [eax + 0x46]

        $sequence_11 = { 744e 0fb74802 83e103 3bcb }
            // n = 4, score = 400
            //   744e                 | je                  0x50
            //   0fb74802             | movzx               ecx, word ptr [eax + 2]
            //   83e103               | and                 ecx, 3
            //   3bcb                 | cmp                 ecx, ebx

        $sequence_12 = { 7508 85f6 7404 c6464101 5e c3 }
            // n = 6, score = 400
            //   7508                 | jne                 0xa
            //   85f6                 | test                esi, esi
            //   7404                 | je                  6
            //   c6464101             | mov                 byte ptr [esi + 0x41], 1
            //   5e                   | pop                 esi
            //   c3                   | ret                 

        $sequence_13 = { 1ac9 2403 80e110 8ad1 3c02 7509 }
            // n = 6, score = 400
            //   1ac9                 | sbb                 cl, cl
            //   2403                 | and                 al, 3
            //   80e110               | and                 cl, 0x10
            //   8ad1                 | mov                 dl, cl
            //   3c02                 | cmp                 al, 2
            //   7509                 | jne                 0xb

        $sequence_14 = { 7505 89410c 8bc1 ffb42484000000 }
            // n = 4, score = 400
            //   7505                 | jne                 7
            //   89410c               | mov                 dword ptr [ecx + 0xc], eax
            //   8bc1                 | mov                 eax, ecx
            //   ffb42484000000       | push                dword ptr [esp + 0x84]

        $sequence_15 = { 85c0 742c 8bd6 8bcb }
            // n = 4, score = 400
            //   85c0                 | test                eax, eax
            //   742c                 | je                  0x2e
            //   8bd6                 | mov                 edx, esi
            //   8bcb                 | mov                 ecx, ebx

        $sequence_16 = { e8???????? 8b5720 8bce e8???????? 8b5724 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8b5720               | mov                 edx, dword ptr [edi + 0x20]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b5724               | mov                 edx, dword ptr [edi + 0x24]

        $sequence_17 = { 8b4d34 894c245c dd85b8fbffff dd5c2454 }
            // n = 4, score = 100
            //   8b4d34               | mov                 ecx, dword ptr [ebp + 0x34]
            //   894c245c             | mov                 dword ptr [esp + 0x5c], ecx
            //   dd85b8fbffff         | fld                 qword ptr [ebp - 0x448]
            //   dd5c2454             | fstp                qword ptr [esp + 0x54]

        $sequence_18 = { 014710 83571400 83c301 8bbe4c010000 8355fc00 }
            // n = 5, score = 100
            //   014710               | add                 dword ptr [edi + 0x10], eax
            //   83571400             | adc                 dword ptr [edi + 0x14], 0
            //   83c301               | add                 ebx, 1
            //   8bbe4c010000         | mov                 edi, dword ptr [esi + 0x14c]
            //   8355fc00             | adc                 dword ptr [ebp - 4], 0

        $sequence_19 = { 8b4d18 8901 895104 e9???????? }
            // n = 4, score = 100
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   895104               | mov                 dword ptr [ecx + 4], edx
            //   e9????????           |                     

        $sequence_20 = { 015e58 8bd7 8b4e60 83565c00 }
            // n = 4, score = 100
            //   015e58               | add                 dword ptr [esi + 0x58], ebx
            //   8bd7                 | mov                 edx, edi
            //   8b4e60               | mov                 ecx, dword ptr [esi + 0x60]
            //   83565c00             | adc                 dword ptr [esi + 0x5c], 0

        $sequence_21 = { 015f28 8bc2 13472c 89472c }
            // n = 4, score = 100
            //   015f28               | add                 dword ptr [edi + 0x28], ebx
            //   8bc2                 | mov                 eax, edx
            //   13472c               | adc                 eax, dword ptr [edi + 0x2c]
            //   89472c               | mov                 dword ptr [edi + 0x2c], eax

        $sequence_22 = { 8b4d14 898d38ffffff 8b8580000000 898534ffffff }
            // n = 4, score = 100
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   898d38ffffff         | mov                 dword ptr [ebp - 0xc8], ecx
            //   8b8580000000         | mov                 eax, dword ptr [ebp + 0x80]
            //   898534ffffff         | mov                 dword ptr [ebp - 0xcc], eax

        $sequence_23 = { 8b4d20 894c2468 8b4d5c 894c2464 }
            // n = 4, score = 100
            //   8b4d20               | mov                 ecx, dword ptr [ebp + 0x20]
            //   894c2468             | mov                 dword ptr [esp + 0x68], ecx
            //   8b4d5c               | mov                 ecx, dword ptr [ebp + 0x5c]
            //   894c2464             | mov                 dword ptr [esp + 0x64], ecx

        $sequence_24 = { 8b4d18 8b09 81c1fc030000 8b448808 }
            // n = 4, score = 100
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   81c1fc030000         | add                 ecx, 0x3fc
            //   8b448808             | mov                 eax, dword ptr [eax + ecx*4 + 8]

        $sequence_25 = { 014e10 134614 837de000 894614 }
            // n = 4, score = 100
            //   014e10               | add                 dword ptr [esi + 0x10], ecx
            //   134614               | adc                 eax, dword ptr [esi + 0x14]
            //   837de000             | cmp                 dword ptr [ebp - 0x20], 0
            //   894614               | mov                 dword ptr [esi + 0x14], eax

        $sequence_26 = { 8b4d24 894c247c dd85b0fbffff dd5c2474 }
            // n = 4, score = 100
            //   8b4d24               | mov                 ecx, dword ptr [ebp + 0x24]
            //   894c247c             | mov                 dword ptr [esp + 0x7c], ecx
            //   dd85b0fbffff         | fld                 qword ptr [ebp - 0x450]
            //   dd5c2474             | fstp                qword ptr [esp + 0x74]

        $sequence_27 = { 8b4d28 898d30ffffff 8b958c000000 89952cffffff }
            // n = 4, score = 100
            //   8b4d28               | mov                 ecx, dword ptr [ebp + 0x28]
            //   898d30ffffff         | mov                 dword ptr [ebp - 0xd0], ecx
            //   8b958c000000         | mov                 edx, dword ptr [ebp + 0x8c]
            //   89952cffffff         | mov                 dword ptr [ebp - 0xd4], edx

        $sequence_28 = { 018330af0100 8b45d8 85c0 7416 }
            // n = 4, score = 100
            //   018330af0100         | add                 dword ptr [ebx + 0x1af30], eax
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18

        $sequence_29 = { 8b4d18 8b09 83c101 81c1fc030000 }
            // n = 4, score = 100
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   83c101               | add                 ecx, 1
            //   81c1fc030000         | add                 ecx, 0x3fc

    condition:
        7 of them and filesize < 17138688
}