rule win_cryptic_convo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cryptic_convo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptic_convo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 57 8bf1 e8???????? ff7674 8b3d???????? 6a01 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   ff7674               | push                dword ptr [esi + 0x74]
            //   8b3d????????         |                     
            //   6a01                 | push                1

        $sequence_1 = { 2b459c ff7674 2bc7 40 99 2bc2 }
            // n = 6, score = 100
            //   2b459c               | sub                 eax, dword ptr [ebp - 0x64]
            //   ff7674               | push                dword ptr [esi + 0x74]
            //   2bc7                 | sub                 eax, edi
            //   40                   | inc                 eax
            //   99                   | cdq                 
            //   2bc2                 | sub                 eax, edx

        $sequence_2 = { c3 6800090000 6a00 e8???????? }
            // n = 4, score = 100
            //   c3                   | ret                 
            //   6800090000           | push                0x900
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_3 = { 034d08 bb00300000 663bd3 7505 }
            // n = 4, score = 100
            //   034d08               | add                 ecx, dword ptr [ebp + 8]
            //   bb00300000           | mov                 ebx, 0x3000
            //   663bd3               | cmp                 dx, bx
            //   7505                 | jne                 7

        $sequence_4 = { 8b450c 53 8985ecfcffff 8b4514 56 8985f0fcffff 57 }
            // n = 7, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   53                   | push                ebx
            //   8985ecfcffff         | mov                 dword ptr [ebp - 0x314], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   56                   | push                esi
            //   8985f0fcffff         | mov                 dword ptr [ebp - 0x310], eax
            //   57                   | push                edi

        $sequence_5 = { 6a5c 85f6 7403 56 }
            // n = 4, score = 100
            //   6a5c                 | push                0x5c
            //   85f6                 | test                esi, esi
            //   7403                 | je                  5
            //   56                   | push                esi

        $sequence_6 = { 7905 4a 83cafe 42 7510 ff85b4feffff 8b95b4feffff }
            // n = 7, score = 100
            //   7905                 | jns                 7
            //   4a                   | dec                 edx
            //   83cafe               | or                  edx, 0xfffffffe
            //   42                   | inc                 edx
            //   7510                 | jne                 0x12
            //   ff85b4feffff         | inc                 dword ptr [ebp - 0x14c]
            //   8b95b4feffff         | mov                 edx, dword ptr [ebp - 0x14c]

        $sequence_7 = { 8b85ecfcffff 8b95f4fcffff 53 ff7510 89540134 50 }
            // n = 6, score = 100
            //   8b85ecfcffff         | mov                 eax, dword ptr [ebp - 0x314]
            //   8b95f4fcffff         | mov                 edx, dword ptr [ebp - 0x30c]
            //   53                   | push                ebx
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   89540134             | mov                 dword ptr [ecx + eax + 0x34], edx
            //   50                   | push                eax

        $sequence_8 = { 50 e8???????? 83c40c 33c0 8a88b0664000 888c05dc010000 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax
            //   8a88b0664000         | mov                 cl, byte ptr [eax + 0x4066b0]
            //   888c05dc010000       | mov                 byte ptr [ebp + eax + 0x1dc], cl

        $sequence_9 = { 3b85d4fcffff 750e 8b4610 03461c 8985a8fdffff eb0b }
            // n = 6, score = 100
            //   3b85d4fcffff         | cmp                 eax, dword ptr [ebp - 0x32c]
            //   750e                 | jne                 0x10
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   03461c               | add                 eax, dword ptr [esi + 0x1c]
            //   8985a8fdffff         | mov                 dword ptr [ebp - 0x258], eax
            //   eb0b                 | jmp                 0xd

    condition:
        7 of them and filesize < 97280
}