rule win_cryptomix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cryptomix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptomix"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? ffd0 683e8d61be 6a06 }
            // n = 4, score = 200
            //   68????????           |                     
            //   ffd0                 | call                eax
            //   683e8d61be           | push                0xbe618d3e
            //   6a06                 | push                6

        $sequence_1 = { ffb580efffff ff15???????? 56 68???????? ff15???????? 68???????? 68???????? }
            // n = 7, score = 200
            //   ffb580efffff         | push                dword ptr [ebp - 0x1080]
            //   ff15????????         |                     
            //   56                   | push                esi
            //   68????????           |                     
            //   ff15????????         |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_2 = { 85c0 0f87e0000000 68???????? 56 e8???????? 59 59 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   0f87e0000000         | ja                  0xe6
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_3 = { 8be5 5d c3 3dc0ede0b7 }
            // n = 4, score = 200
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   3dc0ede0b7           | cmp                 eax, 0xb7e0edc0

        $sequence_4 = { ffb5e0fbffff ff15???????? ff85e8fbffff 8d85e4fbffff 50 68???????? }
            // n = 6, score = 200
            //   ffb5e0fbffff         | push                dword ptr [ebp - 0x420]
            //   ff15????????         |                     
            //   ff85e8fbffff         | inc                 dword ptr [ebp - 0x418]
            //   8d85e4fbffff         | lea                 eax, [ebp - 0x41c]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_5 = { 59 ff742408 ff742408 ffd0 c3 68c142487b 6a01 }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   ff742408             | push                dword ptr [esp + 8]
            //   ff742408             | push                dword ptr [esp + 8]
            //   ffd0                 | call                eax
            //   c3                   | ret                 
            //   68c142487b           | push                0x7b4842c1
            //   6a01                 | push                1

        $sequence_6 = { 8b30 57 8b7dfc 68dee70218 6a05 e8???????? }
            // n = 6, score = 200
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   57                   | push                edi
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   68dee70218           | push                0x1802e7de
            //   6a05                 | push                5
            //   e8????????           |                     

        $sequence_7 = { 68???????? 8d85e8fbffff 50 ffd7 8d85c4f9ffff 50 8d85e8fbffff }
            // n = 7, score = 200
            //   68????????           |                     
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8d85c4f9ffff         | lea                 eax, [ebp - 0x63c]
            //   50                   | push                eax
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]

        $sequence_8 = { 8bf9 e8???????? 83c40c 8d85e0fbffff 50 8d85f4fdffff 50 }
            // n = 7, score = 200
            //   8bf9                 | mov                 edi, ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85e0fbffff         | lea                 eax, [ebp - 0x420]
            //   50                   | push                eax
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax

        $sequence_9 = { c785e4fbffff04010000 ff15???????? 8d85e4fbffff 50 56 }
            // n = 5, score = 200
            //   c785e4fbffff04010000     | mov    dword ptr [ebp - 0x41c], 0x104
            //   ff15????????         |                     
            //   8d85e4fbffff         | lea                 eax, [ebp - 0x41c]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_10 = { 7571 b801000000 8b4dfc 33cd e8???????? 8be5 }
            // n = 6, score = 200
            //   7571                 | jne                 0x73
            //   b801000000           | mov                 eax, 1
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp

        $sequence_11 = { 55 8bec 83ec10 57 33ff 6822ded78a }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   6822ded78a           | push                0x8ad7de22

        $sequence_12 = { 6802f1f808 6a01 e8???????? 83c430 56 6880000000 }
            // n = 6, score = 200
            //   6802f1f808           | push                0x8f8f102
            //   6a01                 | push                1
            //   e8????????           |                     
            //   83c430               | add                 esp, 0x30
            //   56                   | push                esi
            //   6880000000           | push                0x80

        $sequence_13 = { 33c0 8d95f4fdffff 6685c9 0f8465010000 0fb7c9 c1c007 }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   8d95f4fdffff         | lea                 edx, [ebp - 0x20c]
            //   6685c9               | test                cx, cx
            //   0f8465010000         | je                  0x16b
            //   0fb7c9               | movzx               ecx, cx
            //   c1c007               | rol                 eax, 7

        $sequence_14 = { ff75f4 6a40 e8???????? 8bd8 }
            // n = 4, score = 200
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6a40                 | push                0x40
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_15 = { 59 8d4dfc 51 683f020f00 56 bb???????? 53 }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   683f020f00           | push                0xf023f
            //   56                   | push                esi
            //   bb????????           |                     
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 188416
}