rule win_cryptoshield_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cryptoshield."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptoshield"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7405 83f804 751a e8???????? }
            // n = 4, score = 300
            //   7405                 | je                  7
            //   83f804               | cmp                 eax, 4
            //   751a                 | jne                 0x1c
            //   e8????????           |                     

        $sequence_1 = { ff15???????? 83c40c 8d85b0edffff 50 683f020f00 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85b0edffff         | lea                 eax, [ebp - 0x1250]
            //   50                   | push                eax
            //   683f020f00           | push                0xf023f

        $sequence_2 = { 75cb 66833a00 8bfa 744d 8d4900 }
            // n = 5, score = 300
            //   75cb                 | jne                 0xffffffcd
            //   66833a00             | cmp                 word ptr [edx], 0
            //   8bfa                 | mov                 edi, edx
            //   744d                 | je                  0x4f
            //   8d4900               | lea                 ecx, [ecx]

        $sequence_3 = { 6a00 8d85e8fbffff 50 6a01 68???????? 56 ff15???????? }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_4 = { 8d85c4f1ffff 68???????? 50 ffd3 }
            // n = 4, score = 300
            //   8d85c4f1ffff         | lea                 eax, [ebp - 0xe3c]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd3                 | call                ebx

        $sequence_5 = { 50 ffd7 8b45f0 85c0 7506 }
            // n = 5, score = 300
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8

        $sequence_6 = { 0f84a6000000 8d45fc 50 6a01 ff75f8 6810660000 }
            // n = 6, score = 300
            //   0f84a6000000         | je                  0xac
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   6810660000           | push                0x6610

        $sequence_7 = { 6a00 ffd3 85c0 0f84bb000000 6804010000 }
            // n = 5, score = 300
            //   6a00                 | push                0
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   0f84bb000000         | je                  0xc1
            //   6804010000           | push                0x104

        $sequence_8 = { ff15???????? c745fc00000000 85f6 7407 56 ff15???????? 85ff }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   85f6                 | test                esi, esi
            //   7407                 | je                  9
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85ff                 | test                edi, edi

        $sequence_9 = { 0fb7c0 50 8d45f4 68???????? 50 ffd6 83c40c }
            // n = 7, score = 300
            //   0fb7c0               | movzx               eax, ax
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c40c               | add                 esp, 0xc

    condition:
        7 of them and filesize < 131072
}