rule win_cryptowall_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cryptowall."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cryptowall"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 8b482c ffd1 6a00 }
            // n = 5, score = 2100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b482c               | mov                 ecx, dword ptr [eax + 0x2c]
            //   ffd1                 | call                ecx
            //   6a00                 | push                0

        $sequence_1 = { 83ec08 837d0800 7502 eb4f 6a08 6a00 }
            // n = 6, score = 2100
            //   83ec08               | sub                 esp, 8
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7502                 | jne                 4
            //   eb4f                 | jmp                 0x51
            //   6a08                 | push                8
            //   6a00                 | push                0

        $sequence_2 = { e8???????? 83c408 99 b91a000000 }
            // n = 4, score = 2100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   99                   | cdq                 
            //   b91a000000           | mov                 ecx, 0x1a

        $sequence_3 = { 894dfc 837df805 752d 837dfc00 }
            // n = 4, score = 2100
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   837df805             | cmp                 dword ptr [ebp - 8], 5
            //   752d                 | jne                 0x2f
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0

        $sequence_4 = { 83ec18 56 8b450c 50 }
            // n = 4, score = 2100
            //   83ec18               | sub                 esp, 0x18
            //   56                   | push                esi
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax

        $sequence_5 = { 99 b91a000000 f7f9 83c261 8b45f4 }
            // n = 5, score = 2100
            //   99                   | cdq                 
            //   b91a000000           | mov                 ecx, 0x1a
            //   f7f9                 | idiv                ecx
            //   83c261               | add                 edx, 0x61
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_6 = { e8???????? 83c408 8b0d???????? 898114010000 }
            // n = 4, score = 2100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b0d????????         |                     
            //   898114010000         | mov                 dword ptr [ecx + 0x114], eax

        $sequence_7 = { b861000000 668945ee b963000000 66894df0 }
            // n = 4, score = 2100
            //   b861000000           | mov                 eax, 0x61
            //   668945ee             | mov                 word ptr [ebp - 0x12], ax
            //   b963000000           | mov                 ecx, 0x63
            //   66894df0             | mov                 word ptr [ebp - 0x10], cx

        $sequence_8 = { 52 e8???????? 8b400c ffd0 }
            // n = 4, score = 2100
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   ffd0                 | call                eax

        $sequence_9 = { 6880000000 6a00 8d4de8 51 }
            // n = 4, score = 2100
            //   6880000000           | push                0x80
            //   6a00                 | push                0
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 417792
}