rule win_crytox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.crytox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.crytox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 81fb07100000 0f84fcfcffff e9???????? 81fb0c000200 0f86ebfcffff e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   81fb07100000         | mov                 word ptr [ebp - 0x1c], 0xa
            //   0f84fcfcffff         | movsx               eax, word ptr [ebp - 0x28]
            //   e9????????           |                     
            //   81fb0c000200         | add                 eax, 1
            //   0f86ebfcffff         | mov                 eax, dword ptr [ebp + eax*4 - 0x6c]
            //   e9????????           |                     

        $sequence_1 = { f72424 897c2414 8b7c2404 69cf182d0700 89c6 b867fb0900 01ca }
            // n = 7, score = 100
            //   f72424               | test                dl, 8
            //   897c2414             | jne                 0x10a1
            //   8b7c2404             | test                dl, 4
            //   69cf182d0700         | test                dl, 0x20
            //   89c6                 | jne                 0xb09
            //   b867fb0900           | mov                 al, byte ptr [ecx + 1]
            //   01ca                 | shl                 edx, 6

        $sequence_2 = { e8???????? 8945c8 8b45c8 c1f809 89c2 8b45cc c1f809 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8945c8               | mov                 dword ptr [ebx + 4], eax
            //   8b45c8               | mov                 eax, ebx
            //   c1f809               | dec                 eax
            //   89c2                 | je                  0x12a
            //   8b45cc               | jmp                 0x15b
            //   c1f809               | mov                 dword ptr [ebx + 8], eax

        $sequence_3 = { e8???????? 395c2430 75e5 8b7c2460 8b442434 31d2 8b5c2430 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   395c2430             | cmp                 byte ptr [eax], 0
            //   75e5                 | je                  0xad
            //   8b7c2460             | mov                 dword ptr [esp], eax
            //   8b442434             | mov                 dword ptr [esp + 4], 0
            //   31d2                 | xor                 edx, edx
            //   8b5c2430             | cmp                 byte ptr [eax], 0

        $sequence_4 = { c705????????a9bc6600 e9???????? e8???????? 0fb6c0 8983d0470000 8b03 e8???????? }
            // n = 7, score = 100
            //   c705????????a9bc6600     |     
            //   e9????????           |                     
            //   e8????????           |                     
            //   0fb6c0               | mov                 ebx, dword ptr [ebp - 0xc0]
            //   8983d0470000         | cmp                 dword ptr [ebp + 8], 0
            //   8b03                 | mov                 ecx, dword ptr [ebp - 0xcc]
            //   e8????????           |                     

        $sequence_5 = { e8???????? 8b4c2418 894104 8b4104 8938 8b4104 c7400400000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4c2418             | mov                 eax, dword ptr [ebp + 0xc]
            //   894104               | add                 eax, edx
            //   8b4104               | mov                 eax, dword ptr [eax]
            //   8938                 | cmp                 eax, dword ptr [ebp - 0x18]
            //   8b4104               | mov                 eax, dword ptr [ebp - 0xc]
            //   c7400400000000       | mov                 dword ptr [eax], 0

        $sequence_6 = { e8???????? 31c0 eb17 891c24 e8???????? 837d0c00 89f0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   31c0                 | jb                  0x2bf
            //   eb17                 | add                 al, byte ptr [eax]
            //   891c24               | mov                 dword ptr [esp], 5
            //   e8????????           |                     
            //   837d0c00             | sub                 edi, eax
            //   89f0                 | mov                 word ptr [ebx + 0x18], ax

        $sequence_7 = { e8???????? 89442404 8b55d8 8b4208 890424 e8???????? 83f80f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89442404             | mov                 edx, 0x104
            //   8b55d8               | mov                 dword ptr [esp], esi
            //   8b4208               | xor                 eax, eax
            //   890424               | jmp                 0x429
            //   e8????????           |                     
            //   83f80f               | mov                 dword ptr [esp], ebx

        $sequence_8 = { e9???????? c744240477bf6600 891c24 e8???????? 85c0 750f c705????????05000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c744240477bf6600     | mov                 esi, 0xa
            //   891c24               | mov                 esi, 9
            //   e8????????           |                     
            //   85c0                 | mov                 esi, 0xc
            //   750f                 | mov                 eax, dword ptr [ebp - 0x50]
            //   c705????????05000000     |     

        $sequence_9 = { e8???????? e9???????? 807b0300 0f84a7000000 a1????????85c07533 e8???????? 480f8eff010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   807b0300             | mov                 dword ptr [esp], 1
            //   0f84a7000000         | fldz                
            //   a1????????85c07533     |     
            //   e8????????           |                     
            //   480f8eff010000       | fld                 qword ptr [esp + 0x28]

    condition:
        7 of them and filesize < 6156288
}