rule win_cuba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cuba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cuba"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7810 3de4000000 7309 8b04c510704100 5d }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7810                 | js                  0x12
            //   3de4000000           | cmp                 eax, 0xe4
            //   7309                 | jae                 0xb
            //   8b04c510704100       | mov                 eax, dword ptr [eax*8 + 0x417010]
            //   5d                   | pop                 ebp

        $sequence_1 = { c3 8bff 55 8bec 8b4d08 33c0 3b0cc5905d4100 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   33c0                 | xor                 eax, eax
            //   3b0cc5905d4100       | cmp                 ecx, dword ptr [eax*8 + 0x415d90]

        $sequence_2 = { 0019 43 41 00444341 }
            // n = 4, score = 100
            //   0019                 | add                 byte ptr [ecx], bl
            //   43                   | inc                 ebx
            //   41                   | inc                 ecx
            //   00444341             | add                 byte ptr [ebx + eax*2 + 0x41], al

        $sequence_3 = { 8bd6 c745ac749f4100 8bce 0fb707 }
            // n = 4, score = 100
            //   8bd6                 | mov                 edx, esi
            //   c745ac749f4100       | mov                 dword ptr [ebp - 0x54], 0x419f74
            //   8bce                 | mov                 ecx, esi
            //   0fb707               | movzx               eax, word ptr [edi]

        $sequence_4 = { 000d???????? 384100 b538 41 }
            // n = 4, score = 100
            //   000d????????         |                     
            //   384100               | cmp                 byte ptr [ecx], al
            //   b538                 | mov                 ch, 0x38
            //   41                   | inc                 ecx

        $sequence_5 = { 0026 45 41 003a }
            // n = 4, score = 100
            //   0026                 | add                 byte ptr [esi], ah
            //   45                   | inc                 ebp
            //   41                   | inc                 ecx
            //   003a                 | add                 byte ptr [edx], bh

        $sequence_6 = { 0026 43 41 00b043410062 }
            // n = 4, score = 100
            //   0026                 | add                 byte ptr [esi], ah
            //   43                   | inc                 ebx
            //   41                   | inc                 ecx
            //   00b043410062         | add                 byte ptr [eax + 0x62004143], dh

        $sequence_7 = { 0012 45 41 0026 }
            // n = 4, score = 100
            //   0012                 | add                 byte ptr [edx], dl
            //   45                   | inc                 ebp
            //   41                   | inc                 ecx
            //   0026                 | add                 byte ptr [esi], ah

        $sequence_8 = { 83e801 0f8501010000 c745e004934100 8b4508 }
            // n = 4, score = 100
            //   83e801               | sub                 eax, 1
            //   0f8501010000         | jne                 0x107
            //   c745e004934100       | mov                 dword ptr [ebp - 0x20], 0x419304
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_9 = { ff24953c354000 c7878c00000001000000 85c9 747e 3bc6 730a }
            // n = 6, score = 100
            //   ff24953c354000       | jmp                 dword ptr [edx*4 + 0x40353c]
            //   c7878c00000001000000     | mov    dword ptr [edi + 0x8c], 1
            //   85c9                 | test                ecx, ecx
            //   747e                 | je                  0x80
            //   3bc6                 | cmp                 eax, esi
            //   730a                 | jae                 0xc

        $sequence_10 = { 660fc5c400 25f0070000 660f28a040974100 660f28b830934100 660f54f0 660f5cc6 660f59f4 }
            // n = 7, score = 100
            //   660fc5c400           | pextrw              eax, xmm4, 0
            //   25f0070000           | and                 eax, 0x7f0
            //   660f28a040974100     | movapd              xmm4, xmmword ptr [eax + 0x419740]
            //   660f28b830934100     | movapd              xmm7, xmmword ptr [eax + 0x419330]
            //   660f54f0             | andpd               xmm6, xmm0
            //   660f5cc6             | subpd               xmm0, xmm6
            //   660f59f4             | mulpd               xmm6, xmm4

        $sequence_11 = { ffd7 85c0 750c e8???????? 5f }
            // n = 5, score = 100
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_12 = { 000c43 41 0035???????? 43 }
            // n = 4, score = 100
            //   000c43               | add                 byte ptr [ebx + eax*2], cl
            //   41                   | inc                 ecx
            //   0035????????         |                     
            //   43                   | inc                 ebx

        $sequence_13 = { 003a 45 41 004245 }
            // n = 4, score = 100
            //   003a                 | add                 byte ptr [edx], bh
            //   45                   | inc                 ebp
            //   41                   | inc                 ecx
            //   004245               | add                 byte ptr [edx + 0x45], al

        $sequence_14 = { 7414 8d85c0f9ffff 50 56 ff15???????? 85c0 75e6 }
            // n = 7, score = 100
            //   7414                 | je                  0x16
            //   8d85c0f9ffff         | lea                 eax, [ebp - 0x640]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   75e6                 | jne                 0xffffffe8

        $sequence_15 = { 000446 41 00d1 45 }
            // n = 4, score = 100
            //   000446               | add                 byte ptr [esi + eax*2], al
            //   41                   | inc                 ecx
            //   00d1                 | add                 cl, dl
            //   45                   | inc                 ebp

    condition:
        7 of them and filesize < 1094656
}