rule win_cur1_downloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cur1_downloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cur1_downloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d41ff 8b8482c81a0200 85c0 0f84c6000000 413bc7 }
            // n = 5, score = 100
            //   8d41ff               | dec                 eax
            //   8b8482c81a0200       | lea                 edx, [0x23250]
            //   85c0                 | dec                 eax
            //   0f84c6000000         | lea                 ecx, [esp + 0x1d0]
            //   413bc7               | dec                 esp

        $sequence_1 = { 8b4c2450 e8???????? 4889442458 48c744242000000000 4c8d8c24c8000000 448b442450 488b542458 }
            // n = 7, score = 100
            //   8b4c2450             | dec                 eax
            //   e8????????           |                     
            //   4889442458           | mov                 ecx, dword ptr [eax + 0x10]
            //   48c744242000000000     | dec    eax
            //   4c8d8c24c8000000     | mov                 eax, dword ptr [esp + 0x40]
            //   448b442450           | dec                 eax
            //   488b542458           | mov                 eax, dword ptr [eax + 8]

        $sequence_2 = { 83e10f 480fbe841100e40100 8a8c1110e40100 4c2bc0 418b40fc d3e8 }
            // n = 6, score = 100
            //   83e10f               | dec                 eax
            //   480fbe841100e40100     | mov    edx, dword ptr [esp + 0x170]
            //   8a8c1110e40100       | dec                 eax
            //   4c2bc0               | lea                 ecx, [esp + 0x40]
            //   418b40fc             | dec                 eax
            //   d3e8                 | lea                 eax, [esp + 0x30]

        $sequence_3 = { 4863442420 4533c0 0fb6540424 488d0d8da60200 e8???????? 48634c2420 88440c24 }
            // n = 7, score = 100
            //   4863442420           | dec                 esp
            //   4533c0               | mov                 eax, esi
            //   0fb6540424           | dec                 eax
            //   488d0d8da60200       | mov                 eax, dword ptr [esp + 0x40]
            //   e8????????           |                     
            //   48634c2420           | dec                 eax
            //   88440c24             | mov                 eax, dword ptr [eax + 8]

        $sequence_4 = { 488bbc24e0000000 4803fa 488bd7 8b7c2440 486bff0c 488d35aa980200 4803f7 }
            // n = 7, score = 100
            //   488bbc24e0000000     | inc                 ecx
            //   4803fa               | mov                 edx, dword ptr [edx - 4]
            //   488bd7               | inc                 ecx
            //   8b7c2440             | movzx               ecx, byte ptr [edx]
            //   486bff0c             | and                 ecx, 0xf
            //   488d35aa980200       | dec                 edx
            //   4803f7               | movsx               eax, byte ptr [ecx + ebx + 0x1e400]

        $sequence_5 = { 4533c9 4533c0 488d542438 488b8c24d8000000 }
            // n = 4, score = 100
            //   4533c9               | je                  0x7d
            //   4533c0               | dec                 ecx
            //   488d542438           | arpl                word ptr [esi + 8], dx
            //   488b8c24d8000000     | inc                 ecx

        $sequence_6 = { b843000000 6689842486000000 b875000000 6689842488000000 b872000000 668984248a000000 b872000000 }
            // n = 7, score = 100
            //   b843000000           | lea                 eax, [0xb4da]
            //   6689842486000000     | dec                 eax
            //   b875000000           | mov                 edi, ecx
            //   6689842488000000     | dec                 eax
            //   b872000000           | lea                 edx, [0x9808]
            //   668984248a000000     | mov                 ecx, 0x12
            //   b872000000           | dec                 esp

        $sequence_7 = { 4885c0 751e 498bc6 4c8d3d9f39ffff }
            // n = 4, score = 100
            //   4885c0               | mov                 ecx, edx
            //   751e                 | dec                 eax
            //   498bc6               | mov                 edi, dword ptr [esp + 0x510]
            //   4c8d3d9f39ffff       | dec                 eax

        $sequence_8 = { c744242001000000 4533c9 4533c0 488d942420170000 33c9 ff15???????? 89442468 }
            // n = 7, score = 100
            //   c744242001000000     | dec                 eax
            //   4533c9               | mov                 ecx, dword ptr [esp + 0x510]
            //   4533c0               | dec                 eax
            //   488d942420170000     | cmp                 eax, dword ptr [esp + 0x510]
            //   33c9                 | je                  0x567
            //   ff15????????         |                     
            //   89442468             | mov                 ecx, 0x208

        $sequence_9 = { 4889442478 488b4c2430 488b542420 4803d1 488bca e8???????? 488b4c2478 }
            // n = 7, score = 100
            //   4889442478           | dec                 eax
            //   488b4c2430           | mov                 edx, eax
            //   488b542420           | dec                 eax
            //   4803d1               | mov                 ecx, dword ptr [esp + 0x78]
            //   488bca               | movzx               ecx, byte ptr [eax]
            //   e8????????           |                     
            //   488b4c2478           | je                  0x2e2

    condition:
        7 of them and filesize < 402432
}