rule win_cutwail_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cutwail."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cutwail"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f849d000000 ff7510 e8???????? 59 }
            // n = 4, score = 100
            //   0f849d000000         | je                  0xa3
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_1 = { eb14 8b55fc 0355f8 8955fc }
            // n = 4, score = 100
            //   eb14                 | jmp                 0x16
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0355f8               | add                 edx, dword ptr [ebp - 8]
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_2 = { 59 7506 891d???????? 53 57 }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   7506                 | jne                 8
            //   891d????????         |                     
            //   53                   | push                ebx
            //   57                   | push                edi

        $sequence_3 = { 833800 7511 837df800 7e0b }
            // n = 4, score = 100
            //   833800               | cmp                 dword ptr [eax], 0
            //   7511                 | jne                 0x13
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7e0b                 | jle                 0xd

        $sequence_4 = { 6a66 8d8d90f1ffff e8???????? 03c3 }
            // n = 4, score = 100
            //   6a66                 | push                0x66
            //   8d8d90f1ffff         | lea                 ecx, [ebp - 0xe70]
            //   e8????????           |                     
            //   03c3                 | add                 eax, ebx

        $sequence_5 = { 57 ff755c 03c8 51 e8???????? }
            // n = 5, score = 100
            //   57                   | push                edi
            //   ff755c               | push                dword ptr [ebp + 0x5c]
            //   03c8                 | add                 ecx, eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_6 = { 895104 8b8550feffff c7400800c02004 6a00 6a00 }
            // n = 5, score = 100
            //   895104               | mov                 dword ptr [ecx + 4], edx
            //   8b8550feffff         | mov                 eax, dword ptr [ebp - 0x1b0]
            //   c7400800c02004       | mov                 dword ptr [eax + 8], 0x420c000
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_7 = { e8???????? 894604 8b4610 57 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   57                   | push                edi

        $sequence_8 = { 8bec 81ecc4010000 8d8570feffff 50 6802020000 e8???????? 85c0 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81ecc4010000         | sub                 esp, 0x1c4
            //   8d8570feffff         | lea                 eax, [ebp - 0x190]
            //   50                   | push                eax
            //   6802020000           | push                0x202
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_9 = { 51 e8???????? 83c410 8985ecfdffff }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8985ecfdffff         | mov                 dword ptr [ebp - 0x214], eax

        $sequence_10 = { 1bc0 f7d0 234554 e9???????? }
            // n = 4, score = 100
            //   1bc0                 | sbb                 eax, eax
            //   f7d0                 | not                 eax
            //   234554               | and                 eax, dword ptr [ebp + 0x54]
            //   e9????????           |                     

        $sequence_11 = { 6bc912 56 ff742428 8981feb71513 }
            // n = 4, score = 100
            //   6bc912               | imul                ecx, ecx, 0x12
            //   56                   | push                esi
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   8981feb71513         | mov                 dword ptr [ecx + 0x1315b7fe], eax

        $sequence_12 = { 8b95e4fdffff 52 8d85f8fdffff 50 e8???????? 83c408 }
            // n = 6, score = 100
            //   8b95e4fdffff         | mov                 edx, dword ptr [ebp - 0x21c]
            //   52                   | push                edx
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_13 = { 53 53 6a02 e8???????? 894558 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a02                 | push                2
            //   e8????????           |                     
            //   894558               | mov                 dword ptr [ebp + 0x58], eax

        $sequence_14 = { c7854cfeffff00000000 eb0f 8b954cfeffff 83c201 89954cfeffff 83bd4cfeffff03 0f8db5000000 }
            // n = 7, score = 100
            //   c7854cfeffff00000000     | mov    dword ptr [ebp - 0x1b4], 0
            //   eb0f                 | jmp                 0x11
            //   8b954cfeffff         | mov                 edx, dword ptr [ebp - 0x1b4]
            //   83c201               | add                 edx, 1
            //   89954cfeffff         | mov                 dword ptr [ebp - 0x1b4], edx
            //   83bd4cfeffff03       | cmp                 dword ptr [ebp - 0x1b4], 3
            //   0f8db5000000         | jge                 0xbb

        $sequence_15 = { 0f8d23010000 6800020000 6a00 8d95f8fdffff 52 }
            // n = 5, score = 100
            //   0f8d23010000         | jge                 0x129
            //   6800020000           | push                0x200
            //   6a00                 | push                0
            //   8d95f8fdffff         | lea                 edx, [ebp - 0x208]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 262144
}