rule win_cycbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cycbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cycbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c705????????480f4200 8935???????? a3???????? ff15???????? a3???????? 83f8ff 0f84c1000000 }
            // n = 7, score = 100
            //   c705????????480f4200     |     
            //   8935????????         |                     
            //   a3????????           |                     
            //   ff15????????         |                     
            //   a3????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   0f84c1000000         | je                  0xc7

        $sequence_1 = { 895dfc 51 8d4db8 8945cc 895dc8 885db8 e8???????? }
            // n = 7, score = 100
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   51                   | push                ecx
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   895dc8               | mov                 dword ptr [ebp - 0x38], ebx
            //   885db8               | mov                 byte ptr [ebp - 0x48], bl
            //   e8????????           |                     

        $sequence_2 = { 741a ff7590 ff15???????? 85c0 750d ff7590 e8???????? }
            // n = 7, score = 100
            //   741a                 | je                  0x1c
            //   ff7590               | push                dword ptr [ebp - 0x70]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf
            //   ff7590               | push                dword ptr [ebp - 0x70]
            //   e8????????           |                     

        $sequence_3 = { c68424c805000001 e8???????? 53 6a01 8d4c2474 8bf0 }
            // n = 6, score = 100
            //   c68424c805000001     | mov                 byte ptr [esp + 0x5c8], 1
            //   e8????????           |                     
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   8d4c2474             | lea                 ecx, [esp + 0x74]
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { e8???????? 83c418 6a00 8d842488000000 50 8d8c2494010000 51 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   6a00                 | push                0
            //   8d842488000000       | lea                 eax, [esp + 0x88]
            //   50                   | push                eax
            //   8d8c2494010000       | lea                 ecx, [esp + 0x194]
            //   51                   | push                ecx

        $sequence_5 = { 48 7514 8d8550ffffff eb08 8d45c8 eb03 8d45a0 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   7514                 | jne                 0x16
            //   8d8550ffffff         | lea                 eax, [ebp - 0xb0]
            //   eb08                 | jmp                 0xa
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   eb03                 | jmp                 5
            //   8d45a0               | lea                 eax, [ebp - 0x60]

        $sequence_6 = { 59 898580deffff 3bc7 7433 83bd9cdeffff10 8b8588deffff 7306 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   898580deffff         | mov                 dword ptr [ebp - 0x2180], eax
            //   3bc7                 | cmp                 eax, edi
            //   7433                 | je                  0x35
            //   83bd9cdeffff10       | cmp                 dword ptr [ebp - 0x2164], 0x10
            //   8b8588deffff         | mov                 eax, dword ptr [ebp - 0x2178]
            //   7306                 | jae                 8

        $sequence_7 = { 50 ff5110 8985b4fbffff 3bc7 0f857e010000 8b85a8fbffff 8b08 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff5110               | call                dword ptr [ecx + 0x10]
            //   8985b4fbffff         | mov                 dword ptr [ebp - 0x44c], eax
            //   3bc7                 | cmp                 eax, edi
            //   0f857e010000         | jne                 0x184
            //   8b85a8fbffff         | mov                 eax, dword ptr [ebp - 0x458]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_8 = { 50 8d4c2430 e8???????? 8bf0 59 3bf3 752f }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   3bf3                 | cmp                 esi, ebx
            //   752f                 | jne                 0x31

        $sequence_9 = { 33c0 66898580fbffff 6a04 5b 899dbcfbffff c785c0fbffff02000000 899dc4fbffff }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   66898580fbffff       | mov                 word ptr [ebp - 0x480], ax
            //   6a04                 | push                4
            //   5b                   | pop                 ebx
            //   899dbcfbffff         | mov                 dword ptr [ebp - 0x444], ebx
            //   c785c0fbffff02000000     | mov    dword ptr [ebp - 0x440], 2
            //   899dc4fbffff         | mov                 dword ptr [ebp - 0x43c], ebx

    condition:
        7 of them and filesize < 1163264
}