rule win_dadjoke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dadjoke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dadjoke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 57 6800081000 6a00 }
            // n = 4, score = 500
            //   56                   | push                esi
            //   57                   | push                edi
            //   6800081000           | push                0x100800
            //   6a00                 | push                0

        $sequence_1 = { 52 8b4508 0528020000 50 8b0d???????? }
            // n = 5, score = 400
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0528020000           | add                 eax, 0x228
            //   50                   | push                eax
            //   8b0d????????         |                     

        $sequence_2 = { 83ec40 56 57 8d45e0 50 e8???????? }
            // n = 6, score = 400
            //   83ec40               | sub                 esp, 0x40
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 8b45e8 50 e8???????? 83c404 898578ffffff }
            // n = 5, score = 400
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   898578ffffff         | mov                 dword ptr [ebp - 0x88], eax

        $sequence_4 = { e8???????? 83c408 8945f8 8b4d08 8b5110 52 8b45f8 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b5110               | mov                 edx, dword ptr [ecx + 0x10]
            //   52                   | push                edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_5 = { 8845f4 8345d801 807df400 75ee 8b4dd8 }
            // n = 5, score = 400
            //   8845f4               | mov                 byte ptr [ebp - 0xc], al
            //   8345d801             | add                 dword ptr [ebp - 0x28], 1
            //   807df400             | cmp                 byte ptr [ebp - 0xc], 0
            //   75ee                 | jne                 0xfffffff0
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]

        $sequence_6 = { 8b4df4 8dbc0d2cffffff b910000000 8d75ac f3a5 8b55f4 83c240 }
            // n = 7, score = 400
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8dbc0d2cffffff       | lea                 edi, [ebp + ecx - 0xd4]
            //   b910000000           | mov                 ecx, 0x10
            //   8d75ac               | lea                 esi, [ebp - 0x54]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   83c240               | add                 edx, 0x40

        $sequence_7 = { 83c414 8b4df4 64890d00000000 8be5 5d c20800 }
            // n = 6, score = 400
            //   83c414               | add                 esp, 0x14
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8

        $sequence_8 = { 33c9 84c0 0f94c1 8bc1 c3 a1???????? }
            // n = 6, score = 300
            //   33c9                 | xor                 ecx, ecx
            //   84c0                 | test                al, al
            //   0f94c1               | sete                cl
            //   8bc1                 | mov                 eax, ecx
            //   c3                   | ret                 
            //   a1????????           |                     

        $sequence_9 = { 5e c3 8bff 55 8bec 83ec10 33c0 }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   33c0                 | xor                 eax, eax

        $sequence_10 = { e8???????? c3 6a04 e8???????? 59 c3 6a0c }
            // n = 7, score = 300
            //   e8????????           |                     
            //   c3                   | ret                 
            //   6a04                 | push                4
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   6a0c                 | push                0xc

        $sequence_11 = { ff15???????? 85c0 7417 b920000000 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7417                 | je                  0x19
            //   b920000000           | mov                 ecx, 0x20

        $sequence_12 = { 5d c3 6a04 8d458c c7458c80330000 50 }
            // n = 6, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a04                 | push                4
            //   8d458c               | lea                 eax, [ebp - 0x74]
            //   c7458c80330000       | mov                 dword ptr [ebp - 0x74], 0x3380
            //   50                   | push                eax

        $sequence_13 = { 84c0 75ef b82f000000 8d55f4 }
            // n = 4, score = 200
            //   84c0                 | test                al, al
            //   75ef                 | jne                 0xfffffff1
            //   b82f000000           | mov                 eax, 0x2f
            //   8d55f4               | lea                 edx, [ebp - 0xc]

        $sequence_14 = { 6a07 6a00 ff15???????? 85c0 0f881f010000 }
            // n = 5, score = 200
            //   6a07                 | push                7
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f881f010000         | js                  0x125

        $sequence_15 = { 83fe04 7ce7 8d45f4 c645f800 }
            // n = 4, score = 200
            //   83fe04               | cmp                 esi, 4
            //   7ce7                 | jl                  0xffffffe9
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   c645f800             | mov                 byte ptr [ebp - 8], 0

        $sequence_16 = { 7508 807e015a 7502 ffd6 6800400000 }
            // n = 5, score = 200
            //   7508                 | jne                 0xa
            //   807e015a             | cmp                 byte ptr [esi + 1], 0x5a
            //   7502                 | jne                 4
            //   ffd6                 | call                esi
            //   6800400000           | push                0x4000

        $sequence_17 = { 8b1d???????? 51 e8???????? 8bf0 83c404 85f6 }
            // n = 6, score = 200
            //   8b1d????????         |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi

        $sequence_18 = { 0f85b5000000 50 ff15???????? 8d85e4faffff 50 }
            // n = 5, score = 200
            //   0f85b5000000         | jne                 0xbb
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d85e4faffff         | lea                 eax, [ebp - 0x51c]
            //   50                   | push                eax

        $sequence_19 = { d9c9 d9f1 833d????????00 0f85cc140000 }
            // n = 4, score = 200
            //   d9c9                 | fxch                st(1)
            //   d9f1                 | fyl2x               
            //   833d????????00       |                     
            //   0f85cc140000         | jne                 0x14d2

        $sequence_20 = { 6804010000 85c0 57 6a00 }
            // n = 4, score = 100
            //   6804010000           | push                0x104
            //   85c0                 | test                eax, eax
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_21 = { 55 8bec 8b4d0c 85c9 7454 8b5508 8b4514 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   85c9                 | test                ecx, ecx
            //   7454                 | je                  0x56
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_22 = { 83e908 8d7608 660fd60f 8d7f08 8b048db47c7300 ffe0 }
            // n = 6, score = 100
            //   83e908               | sub                 ecx, 8
            //   8d7608               | lea                 esi, [esi + 8]
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048db47c7300       | mov                 eax, dword ptr [ecx*4 + 0x737cb4]
            //   ffe0                 | jmp                 eax

    condition:
        7 of them and filesize < 344064
}