rule win_danabot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.danabot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.danabot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b701c ad 0f1f00 8b4008 }
            // n = 4, score = 400
            //   8b701c               | mov                 esi, dword ptr [eax + 0x1c]
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   0f1f00               | nop                 dword ptr [eax]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]

        $sequence_1 = { 83f838 730b ba38000000 2bd0 }
            // n = 4, score = 400
            //   83f838               | cmp                 eax, 0x38
            //   730b                 | jae                 0xd
            //   ba38000000           | mov                 edx, 0x38
            //   2bd0                 | sub                 edx, eax

        $sequence_2 = { 8d45f8 50 6804010000 8d85e8fdffff 50 }
            // n = 5, score = 400
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   6804010000           | push                0x104
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]
            //   50                   | push                eax

        $sequence_3 = { e8???????? 8b03 50 8b442440 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   50                   | push                eax
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]

        $sequence_4 = { e8???????? eb0e 8d541d00 8bc6 e8???????? 83c340 8d433f }
            // n = 7, score = 400
            //   e8????????           |                     
            //   eb0e                 | jmp                 0x10
            //   8d541d00             | lea                 edx, [ebp + ebx]
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   83c340               | add                 ebx, 0x40
            //   8d433f               | lea                 eax, [ebx + 0x3f]

        $sequence_5 = { 33c9 ba44000000 e8???????? c745b844000000 33c0 8945c0 }
            // n = 6, score = 400
            //   33c9                 | xor                 ecx, ecx
            //   ba44000000           | mov                 edx, 0x44
            //   e8????????           |                     
            //   c745b844000000       | mov                 dword ptr [ebp - 0x48], 0x44
            //   33c0                 | xor                 eax, eax
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax

        $sequence_6 = { e8???????? 50 6aff 8bc6 e8???????? 50 6a01 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   50                   | push                eax
            //   6aff                 | push                -1
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_7 = { 8b55f4 8d45f8 e8???????? 8b55f8 8bc7 }
            // n = 5, score = 400
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   e8????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8bc7                 | mov                 eax, edi

        $sequence_8 = { 6a0e 8b45f8 50 ff15???????? 84c0 7447 33c0 }
            // n = 7, score = 400
            //   6a0e                 | push                0xe
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   84c0                 | test                al, al
            //   7447                 | je                  0x49
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { e8???????? 8bd8 8b17 8bc2 85c0 7407 83e804 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   8bc2                 | mov                 eax, edx
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   83e804               | sub                 eax, 4

    condition:
        7 of them and filesize < 237568
}