rule win_danderspritz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.danderspritz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.danderspritz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 3ac3 7534 4c8b15???????? 483bfb 4d8bca 0f94c2 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   3ac3                 | lea                 ebx, [esp + 0x90]
            //   7534                 | dec                 ecx
            //   4c8b15????????       |                     
            //   483bfb               | mov                 ebx, dword ptr [ebx + 0x10]
            //   4d8bca               | dec                 eax
            //   0f94c2               | cmovne              ecx, esi

        $sequence_1 = { 48894360 4183f802 0f877bfeffff 4183e101 488bcb 418bd1 e8???????? }
            // n = 7, score = 100
            //   48894360             | mov                 ebp, ecx
            //   4183f802             | dec                 eax
            //   0f877bfeffff         | mov                 dword ptr [esp + 0x20], 0xfffffffe
            //   4183e101             | dec                 eax
            //   488bcb               | mov                 dword ptr [eax + 8], ebx
            //   418bd1               | dec                 eax
            //   e8????????           |                     

        $sequence_2 = { 7425 85d2 7421 3bc1 721d 3bc2 7219 }
            // n = 7, score = 100
            //   7425                 | cmp                 eax, ebx
            //   85d2                 | dec                 esp
            //   7421                 | lea                 ecx, [0x25e1]
            //   3bc1                 | mov                 edx, 0x1c16f7f
            //   721d                 | call                dword ptr [eax + 0x38]
            //   3bc2                 | xor                 ebx, ebx
            //   7219                 | cmp                 eax, ebx

        $sequence_3 = { 4053 4883ec30 488bd9 85d2 753d 488d9198010000 488d0d75e60100 }
            // n = 7, score = 100
            //   4053                 | mov                 eax, dword ptr [eax + 0x18]
            //   4883ec30             | dec                 eax
            //   488bd9               | mov                 eax, dword ptr [edx]
            //   85d2                 | mov                 edx, dword ptr [eax + 0x18]
            //   753d                 | inc                 esp
            //   488d9198010000       | cmp                 eax, edx
            //   488d0d75e60100       | jne                 0x5d8

        $sequence_4 = { 83f8ff 7505 e8???????? 8b0d???????? ff15???????? 4885c0 7404 }
            // n = 7, score = 100
            //   83f8ff               | mov                 ebx, dword ptr [esp + 0x30]
            //   7505                 | mov                 eax, 0xf0000002
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   ff15????????         |                     
            //   4885c0               | jmp                 0xfc1
            //   7404                 | dec                 eax

        $sequence_5 = { 4c8d0d5fe60300 4c8d0560e60300 488d1555e60300 488bc8 e8???????? 83f8ff 7525 }
            // n = 7, score = 100
            //   4c8d0d5fe60300       | mov                 ecx, esi
            //   4c8d0560e60300       | mov                 edi, eax
            //   488d1555e60300       | and                 dword ptr [esp + 0xe8], 0xfffffffe
            //   488bc8               | xor                 edx, edx
            //   e8????????           |                     
            //   83f8ff               | inc                 esp
            //   7525                 | lea                 eax, [edx + 0x30]

        $sequence_6 = { 0fb6da 498d4be0 4533c9 448bc0 498bd2 896c2448 66896c2434 }
            // n = 7, score = 100
            //   0fb6da               | mov                 dword ptr [ebx + 8], eax
            //   498d4be0             | dec                 eax
            //   4533c9               | mov                 eax, ebx
            //   448bc0               | dec                 eax
            //   498bd2               | add                 esp, 0x20
            //   896c2448             | dec                 eax
            //   66896c2434           | mov                 dword ptr [edx + ecx*8], eax

        $sequence_7 = { 488bfe 4885f6 759a 8b435c 83635400 894348 }
            // n = 6, score = 100
            //   488bfe               | mov                 ecx, ebx
            //   4885f6               | dec                 eax
            //   759a                 | mov                 ecx, ebx
            //   8b435c               | mov                 eax, edi
            //   83635400             | jmp                 0xd40
            //   894348               | dec                 eax

        $sequence_8 = { 4103fd 488b4538 8a480c 80f9ff 7403 83c708 393e }
            // n = 7, score = 100
            //   4103fd               | call                dword ptr [eax + 0x40]
            //   488b4538             | dec                 eax
            //   8a480c               | lea                 edx, [0x31cc3]
            //   80f9ff               | jmp                 0x1343
            //   7403                 | dec                 eax
            //   83c708               | lea                 ecx, [eax - 0x80]
            //   393e                 | inc                 esp

        $sequence_9 = { 448bc0 ba02000000 488bcf e8???????? b800000010 488b9c2408010000 4881c4c0000000 }
            // n = 7, score = 100
            //   448bc0               | dec                 eax
            //   ba02000000           | mov                 ecx, edi
            //   488bcf               | test                eax, eax
            //   e8????????           |                     
            //   b800000010           | je                  0x1d68
            //   488b9c2408010000     | dec                 eax
            //   4881c4c0000000       | mov                 dword ptr [ebx + 8], edi

    condition:
        7 of them and filesize < 750592
}