rule win_daolpu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.daolpu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.daolpu"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7506 4883c460 5b c3 a804 7409 488d1dbe721100 }
            // n = 7, score = 100
            //   7506                 | mov                 eax, dword ptr [esp + 0x38]
            //   4883c460             | dec                 eax
            //   5b                   | mov                 dword ptr [edi + 0x70], eax
            //   c3                   | dec                 eax
            //   a804                 | lea                 eax, [0x604]
            //   7409                 | dec                 eax
            //   488d1dbe721100       | mov                 dword ptr [edi + 0x28], eax

        $sequence_1 = { 7439 488b442470 488b8080000000 4883c008 4889442438 488b442470 488b4c2438 }
            // n = 7, score = 100
            //   7439                 | dec                 eax
            //   488b442470           | mov                 dword ptr [esp + 0x28], eax
            //   488b8080000000       | dec                 eax
            //   4883c008             | mov                 dword ptr [esp + 0x20], 0
            //   4889442438           | inc                 ecx
            //   488b442470           | mov                 ecx, 0xa86
            //   488b4c2438           | dec                 esp

        $sequence_2 = { 498bf8 488bf2 488bd9 0f85bc000000 80b9ae0a000000 0f85af000000 41b80f000000 }
            // n = 7, score = 100
            //   498bf8               | mov                 eax, edi
            //   488bf2               | lock xadd           dword ptr [ebx + 8], eax
            //   488bd9               | cmp                 eax, 1
            //   0f85bc000000         | jne                 0x101
            //   80b9ae0a000000       | dec                 eax
            //   0f85af000000         | test                ebx, ebx
            //   41b80f000000         | je                  0x11b

        $sequence_3 = { 48ffca 4d85f6 75ec e9???????? 83f840 0f85d0000000 4d8b7610 }
            // n = 7, score = 100
            //   48ffca               | mov                 ebx, dword ptr [ebp - 0x59]
            //   4d85f6               | movups              xmmword ptr [ebx], xmm0
            //   75ec                 | dec                 eax
            //   e9????????           |                     
            //   83f840               | lea                 ecx, [ebp - 0x29]
            //   0f85d0000000         | dec                 eax
            //   4d8b7610             | sub                 edi, 1

        $sequence_4 = { 897c2428 448be2 44896c2424 8944242c 3801 0f8411050000 0f1f840000000000 }
            // n = 7, score = 100
            //   897c2428             | mov                 ecx, ebp
            //   448be2               | dec                 esp
            //   44896c2424           | mov                 eax, dword ptr [edi + 0x18]
            //   8944242c             | dec                 eax
            //   3801                 | lea                 edx, [0xa02d8]
            //   0f8411050000         | dec                 eax
            //   0f1f840000000000     | mov                 ecx, ebp

        $sequence_5 = { e8???????? 8b442428 c1f806 4898 488d0da3a10600 8b542428 83e23f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b442428             | mov                 dword ptr [ebx + 8], esi
            //   c1f806               | dec                 eax
            //   4898                 | lea                 edx, [edi + 0x50]
            //   488d0da3a10600       | dec                 eax
            //   8b542428             | lea                 ecx, [ebx + 0xa0]
            //   83e23f               | dec                 eax

        $sequence_6 = { 498b4c2448 ff15???????? 0f104500 488bcd 410f110424 0f104d10 410f114c2410 }
            // n = 7, score = 100
            //   498b4c2448           | dec                 eax
            //   ff15????????         |                     
            //   0f104500             | mov                 dword ptr [esp + 0x28], eax
            //   488bcd               | dec                 eax
            //   410f110424           | lea                 eax, [0x37a38]
            //   0f104d10             | dec                 eax
            //   410f114c2410         | mov                 dword ptr [esp + 0x20], eax

        $sequence_7 = { 66ffc3 66413bdf 0f864fffffff 488d15adc40a00 498bce e8???????? e9???????? }
            // n = 7, score = 100
            //   66ffc3               | mov                 edx, dword ptr [esp + 0x50]
            //   66413bdf             | dec                 eax
            //   0f864fffffff         | mov                 ecx, dword ptr [eax]
            //   488d15adc40a00       | dec                 eax
            //   498bce               | mov                 dword ptr [esp + 0x88], eax
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_8 = { 7501 cc 48c744242000000000 41b951050000 4c8d05cd131200 488d158e141200 488d0dff151200 }
            // n = 7, score = 100
            //   7501                 | ret                 
            //   cc                   | sbb                 bl, bl
            //   48c744242000000000     | dec    eax
            //   41b951050000         | mov                 eax, dword ptr [esp + 0x20]
            //   4c8d05cd131200       | dec                 eax
            //   488d158e141200       | inc                 eax
            //   488d0dff151200       | dec                 eax

        $sequence_9 = { e8???????? 0f57c0 f30f7f4558 4c896568 488b4d50 4c896550 ba10000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f57c0               | dec                 esp
            //   f30f7f4558           | mov                 dword ptr [esp + 0x20], esi
            //   4c896568             | dec                 eax
            //   488b4d50             | lea                 edx, [0xc4d8c]
            //   4c896550             | dec                 eax
            //   ba10000000           | mov                 ecx, ebx

    condition:
        7 of them and filesize < 2877440
}