rule win_darkbit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkbit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkbit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 488b8c2480050000 48894808 833d????????00 7515 488b8c24b0210000 488908 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b8c2480050000     | lock cmpxchg        dword ptr [ecx], edx
            //   48894808             | sete                cl
            //   833d????????00       |                     
            //   7515                 | test                cl, cl
            //   488b8c24b0210000     | je                  0x1bf8
            //   488908               | shr                 eax, 1

        $sequence_1 = { 488d0505c50f00 4889d9 4889fb 4889f7 4c89c6 e8???????? 488b542450 }
            // n = 7, score = 100
            //   488d0505c50f00       | inc                 esp
            //   4889d9               | movzx               ebp, byte ptr [esp + 0x1d43]
            //   4889fb               | inc                 esp
            //   4889f7               | mov                 byte ptr [esp + 0x2b9], ch
            //   4c89c6               | inc                 esp
            //   e8????????           |                     
            //   488b542450           | movzx               ebp, byte ptr [esp + 0x1d44]

        $sequence_2 = { eb1a 440fb64c341e 418d1411 8d5293 88543c1e 448844341e 4883c002 }
            // n = 7, score = 100
            //   eb1a                 | dec                 eax
            //   440fb64c341e         | mov                 dword ptr [esp + 0x1178], ecx
            //   418d1411             | dec                 eax
            //   8d5293               | lea                 eax, [0x258b50]
            //   88543c1e             | dec                 eax
            //   448844341e           | mov                 dword ptr [esp + 0x16d8], eax
            //   4883c002             | dec                 eax

        $sequence_3 = { 4c8d4301 4c39c6 7331 488d05052b1700 4889d9 4889fb 4889f7 }
            // n = 7, score = 100
            //   4c8d4301             | mov                 ebx, dword ptr [esp + 0xd8]
            //   4c39c6               | dec                 esp
            //   7331                 | mov                 esp, dword ptr [esp + 0xd0]
            //   488d05052b1700       | dec                 esp
            //   4889d9               | mov                 ebp, dword ptr [esp + 0xc8]
            //   4889fb               | dec                 esp
            //   4889f7               | mov                 edi, dword ptr [esp + 0x1a8]

        $sequence_4 = { eb1c 4889c7 488b8c24d0200000 e8???????? 488d3d4f2a2200 e8???????? 6690 }
            // n = 7, score = 100
            //   eb1c                 | mov                 word ptr [esp + 0x12b], 0xfb84
            //   4889c7               | mov                 byte ptr [esp + 0x12d], 0xb
            //   488b8c24d0200000     | nop                 
            //   e8????????           |                     
            //   488d3d4f2a2200       | mov                 word ptr [esp + 0x134], 0xc8e0
            //   e8????????           |                     
            //   6690                 | mov                 byte ptr [esp + 0x136], 0x9a

        $sequence_5 = { e8???????? 4889842460100000 48899c2400010000 488b842480000000 48c7c3ffffffff e8???????? 48899c2480140000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889842460100000     | ret                 
            //   48899c2400010000     | nop                 dword ptr [eax + eax]
            //   488b842480000000     | inc                 ebp
            //   48c7c3ffffffff       | xorps               xmm7, xmm7
            //   e8????????           |                     
            //   48899c2480140000     | dec                 esp

        $sequence_6 = { e8???????? 488d0546a23800 bb26000000 e8???????? 90 4889442408 48895c2410 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d0546a23800       | jne                 0x1ec4
            //   bb26000000           | jmp                 0x1ec9
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   4889442408           | lea                 edi, [0x33931b]
            //   48895c2410           | jne                 0x1ecf

        $sequence_7 = { e8???????? 48898424581c0000 48895c2428 488b0d???????? 48898c24980e0000 488d0547db0700 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48898424581c0000     | movzx               esp, cl
            //   48895c2428           | dec                 esp
            //   488b0d????????       |                     
            //   48898c24980e0000     | lea                 ebp, [0x49a0c2]
            //   488d0547db0700       | inc                 edi
            //   e8????????           |                     

        $sequence_8 = { 488b8c24a8060000 48894808 833d????????00 7514 488b8c24d8220000 488908 488905???????? }
            // n = 7, score = 100
            //   488b8c24a8060000     | movzx               ecx, byte ptr [esp + edi + 0x107]
            //   48894808             | inc                 ecx
            //   833d????????00       |                     
            //   7514                 | lea                 esi, [ecx + esi]
            //   488b8c24d8220000     | lea                 esi, [esi + 0x77]
            //   488908               | inc                 eax
            //   488905????????       |                     

        $sequence_9 = { 4d89d3 49c1ea2a 4983fa40 0f83d6060000 4c8d25576e5200 4f8b14d4 418402 }
            // n = 7, score = 100
            //   4d89d3               | dec                 eax
            //   49c1ea2a             | mov                 esi, dword ptr [esp + 0x5c0]
            //   4983fa40             | dec                 esp
            //   0f83d6060000         | lea                 ecx, [esi + edi]
            //   4c8d25576e5200       | dec                 ebp
            //   4f8b14d4             | add                 eax, ecx
            //   418402               | dec                 ecx

    condition:
        7 of them and filesize < 11612160
}