rule win_darkdew_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkdew."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkdew"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d7e01 3bfb 7ed0 83c8ff eb07 8b04f55c710110 5f }
            // n = 7, score = 100
            //   8d7e01               | lea                 edi, [esi + 1]
            //   3bfb                 | cmp                 edi, ebx
            //   7ed0                 | jle                 0xffffffd2
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb07                 | jmp                 9
            //   8b04f55c710110       | mov                 eax, dword ptr [esi*8 + 0x1001715c]
            //   5f                   | pop                 edi

        $sequence_1 = { 7214 8b49fc 83c223 2bc1 83c0fc 83f81f 0f87860f0000 }
            // n = 7, score = 100
            //   7214                 | jb                  0x16
            //   8b49fc               | mov                 ecx, dword ptr [ecx - 4]
            //   83c223               | add                 edx, 0x23
            //   2bc1                 | sub                 eax, ecx
            //   83c0fc               | add                 eax, -4
            //   83f81f               | cmp                 eax, 0x1f
            //   0f87860f0000         | ja                  0xf8c

        $sequence_2 = { b991000000 8dbd70e2ffff 8bf2 f3a5 b991000000 }
            // n = 5, score = 100
            //   b991000000           | mov                 ecx, 0x91
            //   8dbd70e2ffff         | lea                 edi, [ebp - 0x1d90]
            //   8bf2                 | mov                 esi, edx
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   b991000000           | mov                 ecx, 0x91

        $sequence_3 = { 6804010000 8d85b4fcffff 6a00 50 e8???????? 83c40c }
            // n = 6, score = 100
            //   6804010000           | push                0x104
            //   8d85b4fcffff         | lea                 eax, [ebp - 0x34c]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_4 = { 83fe10 8bbd68ffffff 0f43cf 8d5101 }
            // n = 4, score = 100
            //   83fe10               | cmp                 esi, 0x10
            //   8bbd68ffffff         | mov                 edi, dword ptr [ebp - 0x98]
            //   0f43cf               | cmovae              ecx, edi
            //   8d5101               | lea                 edx, [ecx + 1]

        $sequence_5 = { c745e807000000 668945d4 83fa10 722c 8b4d9c 42 8bc1 }
            // n = 7, score = 100
            //   c745e807000000       | mov                 dword ptr [ebp - 0x18], 7
            //   668945d4             | mov                 word ptr [ebp - 0x2c], ax
            //   83fa10               | cmp                 edx, 0x10
            //   722c                 | jb                  0x2e
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   42                   | inc                 edx
            //   8bc1                 | mov                 eax, ecx

        $sequence_6 = { 8d85e4f7ffff f3a5 50 8d8528faffff b991000000 8bf3 8dbd18f9ffff }
            // n = 7, score = 100
            //   8d85e4f7ffff         | lea                 eax, [ebp - 0x81c]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   50                   | push                eax
            //   8d8528faffff         | lea                 eax, [ebp - 0x5d8]
            //   b991000000           | mov                 ecx, 0x91
            //   8bf3                 | mov                 esi, ebx
            //   8dbd18f9ffff         | lea                 edi, [ebp - 0x6e8]

        $sequence_7 = { 8d9534fcffff 0f43ce 2bd1 8a01 8d4901 88440aff 84c0 }
            // n = 7, score = 100
            //   8d9534fcffff         | lea                 edx, [ebp - 0x3cc]
            //   0f43ce               | cmovae              ecx, esi
            //   2bd1                 | sub                 edx, ecx
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   88440aff             | mov                 byte ptr [edx + ecx - 1], al
            //   84c0                 | test                al, al

        $sequence_8 = { 83c404 83781408 7202 8b00 50 6a00 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_9 = { eb07 8b0cc5645c0110 894de4 85c9 7455 8b4510 }
            // n = 6, score = 100
            //   eb07                 | jmp                 9
            //   8b0cc5645c0110       | mov                 ecx, dword ptr [eax*8 + 0x10015c64]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   85c9                 | test                ecx, ecx
            //   7455                 | je                  0x57
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 279552
}