rule win_darkloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8365fc00 ff15???????? 59 85c0 b9???????? }
            // n = 5, score = 100
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   b9????????           |                     

        $sequence_1 = { 68???????? ffb7dc010000 8987d4010000 ffd6 }
            // n = 4, score = 100
            //   68????????           |                     
            //   ffb7dc010000         | push                dword ptr [edi + 0x1dc]
            //   8987d4010000         | mov                 dword ptr [edi + 0x1d4], eax
            //   ffd6                 | call                esi

        $sequence_2 = { 83f9ff 75bb 8bb42424020000 8dbe10a10010 ff742418 e8???????? 59 }
            // n = 7, score = 100
            //   83f9ff               | cmp                 ecx, -1
            //   75bb                 | jne                 0xffffffbd
            //   8bb42424020000       | mov                 esi, dword ptr [esp + 0x224]
            //   8dbe10a10010         | lea                 edi, [esi + 0x1000a110]
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_3 = { 8931 e8???????? 83c410 33c0 40 ebaf 83ec18 }
            // n = 7, score = 100
            //   8931                 | mov                 dword ptr [ecx], esi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   ebaf                 | jmp                 0xffffffb1
            //   83ec18               | sub                 esp, 0x18

        $sequence_4 = { 8b01 ff90d0000000 83f809 7555 }
            // n = 4, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff90d0000000         | call                dword ptr [eax + 0xd0]
            //   83f809               | cmp                 eax, 9
            //   7555                 | jne                 0x57

        $sequence_5 = { 68???????? eb38 8d042f 50 e8???????? }
            // n = 5, score = 100
            //   68????????           |                     
            //   eb38                 | jmp                 0x3a
            //   8d042f               | lea                 eax, [edi + ebp]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { 56 57 e8???????? 8bd8 59 59 85ff }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85ff                 | test                edi, edi

        $sequence_7 = { ffb7dc010000 894704 ffd6 68???????? }
            // n = 4, score = 100
            //   ffb7dc010000         | push                dword ptr [edi + 0x1dc]
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   ffd6                 | call                esi
            //   68????????           |                     

        $sequence_8 = { 6a08 8bf8 be???????? 59 8d442414 f3a5 }
            // n = 6, score = 100
            //   6a08                 | push                8
            //   8bf8                 | mov                 edi, eax
            //   be????????           |                     
            //   59                   | pop                 ecx
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_9 = { a3???????? 5e c3 55 8bec 81ec04040000 33c9 }
            // n = 7, score = 100
            //   a3????????           |                     
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec04040000         | sub                 esp, 0x404
            //   33c9                 | xor                 ecx, ecx

    condition:
        7 of them and filesize < 124928
}