rule win_darkpulsar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkpulsar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkpulsar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c21000 ff25???????? ff25???????? ff25???????? 33c0 40 }
            // n = 6, score = 600
            //   c21000               | ret                 0x10
            //   ff25????????         |                     
            //   ff25????????         |                     
            //   ff25????????         |                     
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_1 = { 33c0 40 c20c00 68???????? 64ff3500000000 }
            // n = 5, score = 600
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   c20c00               | ret                 0xc
            //   68????????           |                     
            //   64ff3500000000       | push                dword ptr fs:[0]

        $sequence_2 = { 3a01 1bc0 83e0fe 40 }
            // n = 4, score = 400
            //   3a01                 | cmp                 al, byte ptr [ecx]
            //   1bc0                 | sbb                 eax, eax
            //   83e0fe               | and                 eax, 0xfffffffe
            //   40                   | inc                 eax

        $sequence_3 = { 8b35???????? 57 8b7d08 eb09 803f00 }
            // n = 5, score = 300
            //   8b35????????         |                     
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   eb09                 | jmp                 0xb
            //   803f00               | cmp                 byte ptr [edi], 0

        $sequence_4 = { ffd6 8bd8 8b450c 0fbe00 50 ffd6 }
            // n = 6, score = 300
            //   ffd6                 | call                esi
            //   8bd8                 | mov                 ebx, eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0fbe00               | movsx               eax, byte ptr [eax]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_5 = { ffd6 59 59 3bd8 74e0 }
            // n = 5, score = 300
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   3bd8                 | cmp                 ebx, eax
            //   74e0                 | je                  0xffffffe2

        $sequence_6 = { 47 ff450c 0fbe07 50 ffd6 8bd8 8b450c }
            // n = 7, score = 300
            //   47                   | inc                 edi
            //   ff450c               | inc                 dword ptr [ebp + 0xc]
            //   0fbe07               | movsx               eax, byte ptr [edi]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8bd8                 | mov                 ebx, eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_7 = { 3bd8 74e0 0fb607 8b4d0c 3a01 }
            // n = 5, score = 300
            //   3bd8                 | cmp                 ebx, eax
            //   74e0                 | je                  0xffffffe2
            //   0fb607               | movzx               eax, byte ptr [edi]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   3a01                 | cmp                 al, byte ptr [ecx]

        $sequence_8 = { 5e c9 c3 56 8b742408 85f6 7412 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   85f6                 | test                esi, esi
            //   7412                 | je                  0x14

        $sequence_9 = { ff75fc ff75f4 e8???????? 59 59 83f8ff }
            // n = 6, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   83f8ff               | cmp                 eax, -1

        $sequence_10 = { 33d2 56 57 33c0 }
            // n = 4, score = 200
            //   33d2                 | xor                 edx, edx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax

        $sequence_11 = { 8d45cc 50 57 e8???????? 83c410 85c0 }
            // n = 6, score = 200
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax

        $sequence_12 = { ffd7 59 5f 5e c3 8b4c2404 }
            // n = 6, score = 200
            //   ffd7                 | call                edi
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]

        $sequence_13 = { 50 ff7618 ff15???????? 59 59 85c0 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ff7618               | push                dword ptr [esi + 0x18]
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_14 = { 8945fc 8b450c 53 8b5d08 56 57 8945e8 }
            // n = 7, score = 200
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_15 = { 83c410 83f8ff 0f95c1 49 8bc1 }
            // n = 5, score = 200
            //   83c410               | add                 esp, 0x10
            //   83f8ff               | cmp                 eax, -1
            //   0f95c1               | setne               cl
            //   49                   | dec                 ecx
            //   8bc1                 | mov                 eax, ecx

        $sequence_16 = { 59 1bc0 59 40 c3 e9???????? }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   1bc0                 | sbb                 eax, eax
            //   59                   | pop                 ecx
            //   40                   | inc                 eax
            //   c3                   | ret                 
            //   e9????????           |                     

        $sequence_17 = { 6a01 ff15???????? 8bf0 59 59 3bf7 }
            // n = 6, score = 200
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   3bf7                 | cmp                 esi, edi

        $sequence_18 = { 33d2 c3 8bff 55 8bec b863736de0 }
            // n = 6, score = 200
            //   33d2                 | xor                 edx, edx
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   b863736de0           | mov                 eax, 0xe06d7363

        $sequence_19 = { 53 8b5d10 56 8b7508 33d2 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33d2                 | xor                 edx, edx

        $sequence_20 = { 56 e8???????? 59 85c0 7625 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7625                 | jbe                 0x27

        $sequence_21 = { 8d4601 6a01 50 ff15???????? 8bf8 }
            // n = 5, score = 200
            //   8d4601               | lea                 eax, [esi + 1]
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_22 = { eb03 83c8ff 5f 5e c3 56 }
            // n = 6, score = 200
            //   eb03                 | jmp                 5
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_23 = { 59 5e 8b45fc c9 c3 }
            // n = 5, score = 200
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_24 = { e8???????? 8bf0 46 56 ff15???????? 59 59 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   46                   | inc                 esi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_25 = { e8???????? 59 5e 83f8ff }
            // n = 4, score = 200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   83f8ff               | cmp                 eax, -1

        $sequence_26 = { 5f 5e c3 8b442404 85c0 7503 }
            // n = 6, score = 200
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   85c0                 | test                eax, eax
            //   7503                 | jne                 5

        $sequence_27 = { 56 57 8b7d10 7e05 83c220 eb03 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   7e05                 | jle                 7
            //   83c220               | add                 edx, 0x20
            //   eb03                 | jmp                 5

        $sequence_28 = { 6a7f 58 33f6 83e107 46 d3e6 85f0 }
            // n = 7, score = 100
            //   6a7f                 | push                0x7f
            //   58                   | pop                 eax
            //   33f6                 | xor                 esi, esi
            //   83e107               | and                 ecx, 7
            //   46                   | inc                 esi
            //   d3e6                 | shl                 esi, cl
            //   85f0                 | test                eax, esi

        $sequence_29 = { 8bf8 85ff 750f 50 50 8d45f4 }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   750f                 | jne                 0x11
            //   50                   | push                eax
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_30 = { 50 ffd7 f6450801 5f 7409 56 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   f6450801             | test                byte ptr [ebp + 8], 1
            //   5f                   | pop                 edi
            //   7409                 | je                  0xb
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_31 = { 33ff 895dfc 3bc7 7509 8b0b }
            // n = 5, score = 100
            //   33ff                 | xor                 edi, edi
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   3bc7                 | cmp                 eax, edi
            //   7509                 | jne                 0xb
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_32 = { e8???????? 83c40c 83f8ff 740e ff75e4 ff15???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   83f8ff               | cmp                 eax, -1
            //   740e                 | je                  0x10
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     

        $sequence_33 = { eb28 57 8d45f4 56 50 e8???????? }
            // n = 6, score = 100
            //   eb28                 | jmp                 0x2a
            //   57                   | push                edi
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_34 = { ff742410 ff742410 ff15???????? 33c9 }
            // n = 4, score = 100
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff15????????         |                     
            //   33c9                 | xor                 ecx, ecx

        $sequence_35 = { c20400 8b4508 8b10 8b4008 8d4e08 51 }
            // n = 6, score = 100
            //   c20400               | ret                 4
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   8d4e08               | lea                 ecx, [esi + 8]
            //   51                   | push                ecx

        $sequence_36 = { 8b7d08 837f3c04 7405 33c0 5f 5d }
            // n = 6, score = 100
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   837f3c04             | cmp                 dword ptr [edi + 0x3c], 4
            //   7405                 | je                  7
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp

        $sequence_37 = { 8b7d14 8975f4 3b37 7734 8b750c }
            // n = 5, score = 100
            //   8b7d14               | mov                 edi, dword ptr [ebp + 0x14]
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   3b37                 | cmp                 esi, dword ptr [edi]
            //   7734                 | ja                  0x36
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]

        $sequence_38 = { ff25???????? c3 8b442404 c705????????00102500 c705????????10102500 }
            // n = 5, score = 100
            //   ff25????????         |                     
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   c705????????00102500     |     
            //   c705????????10102500     |     

        $sequence_39 = { 56 ff15???????? 83f8ff 7433 33c0 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   7433                 | je                  0x35
            //   33c0                 | xor                 eax, eax

        $sequence_40 = { 0f841b010000 3bf0 0f8413010000 394708 0f840a010000 894608 }
            // n = 6, score = 100
            //   0f841b010000         | je                  0x121
            //   3bf0                 | cmp                 esi, eax
            //   0f8413010000         | je                  0x119
            //   394708               | cmp                 dword ptr [edi + 8], eax
            //   0f840a010000         | je                  0x110
            //   894608               | mov                 dword ptr [esi + 8], eax

        $sequence_41 = { 8b442408 884101 c1e808 8801 8d4102 }
            // n = 5, score = 100
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   884101               | mov                 byte ptr [ecx + 1], al
            //   c1e808               | shr                 eax, 8
            //   8801                 | mov                 byte ptr [ecx], al
            //   8d4102               | lea                 eax, [ecx + 2]

        $sequence_42 = { ddd9 f6c444 7b09 ddd8 b8???????? eb5b 51 }
            // n = 7, score = 100
            //   ddd9                 | fstp                st(1)
            //   f6c444               | test                ah, 0x44
            //   7b09                 | jnp                 0xb
            //   ddd8                 | fstp                st(0)
            //   b8????????           |                     
            //   eb5b                 | jmp                 0x5d
            //   51                   | push                ecx

        $sequence_43 = { 33ff 8945f4 8945f8 e8???????? 83c404 8945fc }
            // n = 6, score = 100
            //   33ff                 | xor                 edi, edi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_44 = { 8945fc bacdab0000 8d45f4 52 50 }
            // n = 5, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   bacdab0000           | mov                 edx, 0xabcd
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_45 = { 894588 7404 40 894588 83659800 85c0 0f8610010000 }
            // n = 7, score = 100
            //   894588               | mov                 dword ptr [ebp - 0x78], eax
            //   7404                 | je                  6
            //   40                   | inc                 eax
            //   894588               | mov                 dword ptr [ebp - 0x78], eax
            //   83659800             | and                 dword ptr [ebp - 0x68], 0
            //   85c0                 | test                eax, eax
            //   0f8610010000         | jbe                 0x116

        $sequence_46 = { 00db 7309 7515 8a1e }
            // n = 4, score = 100
            //   00db                 | add                 bl, bl
            //   7309                 | jae                 0xb
            //   7515                 | jne                 0x17
            //   8a1e                 | mov                 bl, byte ptr [esi]

        $sequence_47 = { 85f6 7425 3b4d10 0f8394010000 8b7514 }
            // n = 5, score = 100
            //   85f6                 | test                esi, esi
            //   7425                 | je                  0x27
            //   3b4d10               | cmp                 ecx, dword ptr [ebp + 0x10]
            //   0f8394010000         | jae                 0x19a
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]

        $sequence_48 = { e8???????? dc1d???????? 83c410 dfe0 f6c444 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   dc1d????????         |                     
            //   83c410               | add                 esp, 0x10
            //   dfe0                 | fnstsw              ax
            //   f6c444               | test                ah, 0x44

    condition:
        7 of them and filesize < 491520
}