rule win_darkvnc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.darkvnc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkvnc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 428994817c120000 48638178540000 891481 ff8178540000 c3 8bc2 41b2ff }
            // n = 7, score = 100
            //   428994817c120000     | lea                 eax, [0xffffefd1]
            //   48638178540000       | inc                 ebp
            //   891481               | test                ebp, ebp
            //   ff8178540000         | dec                 eax
            //   c3                   | mov                 dword ptr [esp + 0x38], ebx
            //   8bc2                 | mov                 dword ptr [esp + 0x30], 0xa7
            //   41b2ff               | mov                 dword ptr [esp + 0x28], 0x207

        $sequence_1 = { 81f9f4010000 7265 488bd5 898708030000 488bcf e8???????? 488b4768 }
            // n = 7, score = 100
            //   81f9f4010000         | add                 dword ptr [ebx + 0x28], ebp
            //   7265                 | inc                 cx
            //   488bd5               | shr                 eax, cl
            //   898708030000         | add                 dword ptr [ebx + 0x170c], -0xd
            //   488bcf               | mov                 byte ptr [edx + ecx], al
            //   e8????????           |                     
            //   488b4768             | mov                 ecx, 0x10

        $sequence_2 = { 4c8bc1 ebdd 81fba3000000 0f8583000000 33d2 488bcf ff15???????? }
            // n = 7, score = 100
            //   4c8bc1               | inc                 ecx
            //   ebdd                 | movsx               edx, byte ptr [eax]
            //   81fba3000000         | inc                 ecx
            //   0f8583000000         | mov                 al, byte ptr [eax + 2]
            //   33d2                 | jae                 0x183
            //   488bcf               | dec                 eax
            //   ff15????????         |                     

        $sequence_3 = { 4c8bf9 4889b5b8020000 4889bdc0020000 488d1508df0000 488d4d00 33ff 4d8be1 }
            // n = 7, score = 100
            //   4c8bf9               | dec                 eax
            //   4889b5b8020000       | test                ecx, ecx
            //   4889bdc0020000       | je                  0x123c
            //   488d1508df0000       | je                  0x122e
            //   488d4d00             | dec                 eax
            //   33ff                 | mov                 ecx, dword ptr [ecx + 0x38]
            //   4d8be1               | dec                 eax

        $sequence_4 = { 488d542420 488bcf e8???????? 8bd8 488b0d???????? 4c8bc7 33d2 }
            // n = 7, score = 100
            //   488d542420           | mov                 dword ptr [esp + 0x48], eax
            //   488bcf               | dec                 esp
            //   e8????????           |                     
            //   8bd8                 | lea                 edi, [0x884c]
            //   488b0d????????       |                     
            //   4c8bc7               | xor                 eax, eax
            //   33d2                 | dec                 eax

        $sequence_5 = { 740c 498bd7 488bcb ff15???????? 4d85f6 740c }
            // n = 6, score = 100
            //   740c                 | inc                 ecx
            //   498bd7               | mov                 eax, 0x52
            //   488bcb               | jmp                 0x1e34
            //   ff15????????         |                     
            //   4d85f6               | dec                 eax
            //   740c                 | arpl                bx, ax

        $sequence_6 = { f645e801 7425 8b8f80000000 85c9 0f94c0 a801 7436 }
            // n = 7, score = 100
            //   f645e801             | add                 edi, 0xe
            //   7425                 | mov                 esi, eax
            //   8b8f80000000         | xor                 edx, edx
            //   85c9                 | inc                 ecx
            //   0f94c0               | mov                 eax, 0x400
            //   a801                 | inc                 ebp
            //   7436                 | xor                 esp, esp

        $sequence_7 = { e9???????? 488b442448 4889442460 488b442460 4863403c 488b4c2460 4803c8 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b442448           | jmp                 0xbb
            //   4889442460           | dec                 eax
            //   488b442460           | lea                 edx, [esp + 0x20]
            //   4863403c             | mov                 dword ptr [esp + 0x20], 0x238
            //   488b4c2460           | dec                 eax
            //   4803c8               | mov                 ecx, eax

        $sequence_8 = { 83caff ff15???????? 488d55e0 488bcb e8???????? 488b8be8070000 ff15???????? }
            // n = 7, score = 100
            //   83caff               | dec                 eax
            //   ff15????????         |                     
            //   488d55e0             | mov                 dword ptr [esp + 0x20], 0
            //   488bcb               | inc                 ebp
            //   e8????????           |                     
            //   488b8be8070000       | xor                 ecx, ecx
            //   ff15????????         |                     

        $sequence_9 = { 4889842480000000 4883bc24800000000d 0f874b070000 488d0577f9feff 488b8c2480000000 8b8c88dc0d0100 }
            // n = 6, score = 100
            //   4889842480000000     | mov                 eax, dword ptr [ebp + 0xb0]
            //   4883bc24800000000d     | dec    eax
            //   0f874b070000         | mov                 dword ptr [esp + 0x40], eax
            //   488d0577f9feff       | je                  0x13fc
            //   488b8c2480000000     | dec                 eax
            //   8b8c88dc0d0100       | lea                 edx, [0x33081]

    condition:
        7 of them and filesize < 606208
}