rule win_daserf_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.daserf."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.daserf"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d1b 0f8e0d010000 87db 8d8568bfffff 8d1b }
            // n = 5, score = 100
            //   8d1b                 | lea                 ebx, [ebx]
            //   0f8e0d010000         | jle                 0x113
            //   87db                 | xchg                ebx, ebx
            //   8d8568bfffff         | lea                 eax, [ebp - 0x4098]
            //   8d1b                 | lea                 ebx, [ebx]

        $sequence_1 = { 56 ff15???????? ff75f8 8b35???????? ffd6 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   8b35????????         |                     
            //   ffd6                 | call                esi

        $sequence_2 = { 9b 68???????? 8bd2 50 f7d0 f7d0 }
            // n = 6, score = 100
            //   9b                   | wait                
            //   68????????           |                     
            //   8bd2                 | mov                 edx, edx
            //   50                   | push                eax
            //   f7d0                 | not                 eax
            //   f7d0                 | not                 eax

        $sequence_3 = { 6800280000 8d09 8d8568bfffff f7d1 f7d1 53 90 }
            // n = 7, score = 100
            //   6800280000           | push                0x2800
            //   8d09                 | lea                 ecx, [ecx]
            //   8d8568bfffff         | lea                 eax, [ebp - 0x4098]
            //   f7d1                 | not                 ecx
            //   f7d1                 | not                 ecx
            //   53                   | push                ebx
            //   90                   | nop                 

        $sequence_4 = { ff15???????? c705????????01000000 50 53 2d907cb3df }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   c705????????01000000     |     
            //   50                   | push                eax
            //   53                   | push                ebx
            //   2d907cb3df           | sub                 eax, 0xdfb37c90

        $sequence_5 = { 81ebfff91e8d 81c3fb8dd0b7 2d4e5b5869 2db747503f 05dc183929 81eb25261cb5 }
            // n = 6, score = 100
            //   81ebfff91e8d         | sub                 ebx, 0x8d1ef9ff
            //   81c3fb8dd0b7         | add                 ebx, 0xb7d08dfb
            //   2d4e5b5869           | sub                 eax, 0x69585b4e
            //   2db747503f           | sub                 eax, 0x3f5047b7
            //   05dc183929           | add                 eax, 0x293918dc
            //   81eb25261cb5         | sub                 ebx, 0xb51c2625

        $sequence_6 = { 05e81801ee 95 89ac2400f1ffff 8be8 8b842400f1ffff 81c38b11c7c3 }
            // n = 6, score = 100
            //   05e81801ee           | add                 eax, 0xee0118e8
            //   95                   | xchg                eax, ebp
            //   89ac2400f1ffff       | mov                 dword ptr [esp - 0xf00], ebp
            //   8be8                 | mov                 ebp, eax
            //   8b842400f1ffff       | mov                 eax, dword ptr [esp - 0xf00]
            //   81c38b11c7c3         | add                 ebx, 0xc3c7118b

        $sequence_7 = { 2d14be6b51 81c37f189ce5 05a5174ceb 81eb5a34b440 }
            // n = 4, score = 100
            //   2d14be6b51           | sub                 eax, 0x516bbe14
            //   81c37f189ce5         | add                 ebx, 0xe59c187f
            //   05a5174ceb           | add                 eax, 0xeb4c17a5
            //   81eb5a34b440         | sub                 ebx, 0x40b4345a

        $sequence_8 = { b8???????? e9???????? 6a0b e9???????? 50 }
            // n = 5, score = 100
            //   b8????????           |                     
            //   e9????????           |                     
            //   6a0b                 | push                0xb
            //   e9????????           |                     
            //   50                   | push                eax

        $sequence_9 = { 81c38ae02de5 81ebb92f9b23 81eb42c7a1f2 81eb74c57063 2d0f027a7d 2db2e0f8da }
            // n = 6, score = 100
            //   81c38ae02de5         | add                 ebx, 0xe52de08a
            //   81ebb92f9b23         | sub                 ebx, 0x239b2fb9
            //   81eb42c7a1f2         | sub                 ebx, 0xf2a1c742
            //   81eb74c57063         | sub                 ebx, 0x6370c574
            //   2d0f027a7d           | sub                 eax, 0x7d7a020f
            //   2db2e0f8da           | sub                 eax, 0xdaf8e0b2

        $sequence_10 = { f7d6 f7d6 81eb8054748e f7d6 f7d6 81c3cb6fc0a8 }
            // n = 6, score = 100
            //   f7d6                 | not                 esi
            //   f7d6                 | not                 esi
            //   81eb8054748e         | sub                 ebx, 0x8e745480
            //   f7d6                 | not                 esi
            //   f7d6                 | not                 esi
            //   81c3cb6fc0a8         | add                 ebx, 0xa8c06fcb

        $sequence_11 = { 050a037e0a 81ebd4a1a6fb 81c34646dc3b 81c351fc1576 81c3eeb6e6f5 2d8cb08456 }
            // n = 6, score = 100
            //   050a037e0a           | add                 eax, 0xa7e030a
            //   81ebd4a1a6fb         | sub                 ebx, 0xfba6a1d4
            //   81c34646dc3b         | add                 ebx, 0x3bdc4646
            //   81c351fc1576         | add                 ebx, 0x7615fc51
            //   81c3eeb6e6f5         | add                 ebx, 0xf5e6b6ee
            //   2d8cb08456           | sub                 eax, 0x5684b08c

        $sequence_12 = { 0589639a4f 81ebc4cfca9c 05e0940a91 81c3df202492 81c304600bef 81eba197b1b7 }
            // n = 6, score = 100
            //   0589639a4f           | add                 eax, 0x4f9a6389
            //   81ebc4cfca9c         | sub                 ebx, 0x9ccacfc4
            //   05e0940a91           | add                 eax, 0x910a94e0
            //   81c3df202492         | add                 ebx, 0x922420df
            //   81c304600bef         | add                 ebx, 0xef0b6004
            //   81eba197b1b7         | sub                 ebx, 0xb7b197a1

        $sequence_13 = { 2def0da659 87f6 81eb1c07b732 8bc0 }
            // n = 4, score = 100
            //   2def0da659           | sub                 eax, 0x59a60def
            //   87f6                 | xchg                esi, esi
            //   81eb1c07b732         | sub                 ebx, 0x32b7071c
            //   8bc0                 | mov                 eax, eax

        $sequence_14 = { 81c3787cc718 2ddbcfa691 81c3b7415b90 81c3838339ae 2d5988c64e }
            // n = 5, score = 100
            //   81c3787cc718         | add                 ebx, 0x18c77c78
            //   2ddbcfa691           | sub                 eax, 0x91a6cfdb
            //   81c3b7415b90         | add                 ebx, 0x905b41b7
            //   81c3838339ae         | add                 ebx, 0xae398383
            //   2d5988c64e           | sub                 eax, 0x4ec68859

        $sequence_15 = { 81c38cf537b9 9b 81c339ec068e 7500 053941cb1e }
            // n = 5, score = 100
            //   81c38cf537b9         | add                 ebx, 0xb937f58c
            //   9b                   | wait                
            //   81c339ec068e         | add                 ebx, 0x8e06ec39
            //   7500                 | jne                 2
            //   053941cb1e           | add                 eax, 0x1ecb4139

    condition:
        7 of them and filesize < 245760
}