rule win_data_exfiltrator_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.data_exfiltrator."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.data_exfiltrator"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 48837c246800 7504 33c0 eb19 488b542450 488b4c2468 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   48837c246800         | dec                 eax
            //   7504                 | mov                 eax, dword ptr [esp + 0x38]
            //   33c0                 | cmp                 dword ptr [eax + 0x10], 0
            //   eb19                 | jne                 0x7c5
            //   488b542450           | dec                 eax
            //   488b4c2468           | mov                 eax, dword ptr [esp + 0x70]

        $sequence_1 = { 488b442430 8b4c2438 89480c 488b442430 4881c4e8000000 c3 }
            // n = 6, score = 100
            //   488b442430           | mov                 byte ptr [esp + 0x18], al
            //   8b4c2438             | dec                 eax
            //   89480c               | mov                 dword ptr [esp + 0x10], edx
            //   488b442430           | mov                 eax, 1
            //   4881c4e8000000       | dec                 eax
            //   c3                   | add                 esp, 0x48

        $sequence_2 = { 488d152b530000 488b4c2440 ff15???????? 4889442420 }
            // n = 4, score = 100
            //   488d152b530000       | mov                 dword ptr [esp + 0x20], ecx
            //   488b4c2440           | dec                 eax
            //   ff15????????         |                     
            //   4889442420           | mov                 eax, dword ptr [esp + 0x30]

        $sequence_3 = { 8a442470 88442440 48c744243800000000 488d0595c8ffff 4889442430 488d0555d9ffff 4889442428 }
            // n = 7, score = 100
            //   8a442470             | mov                 byte ptr [esp + 0x2b], 0x5d
            //   88442440             | mov                 byte ptr [esp + 0x2c], 0x71
            //   48c744243800000000     | mov    byte ptr [esp + 0x2d], 0x7b
            //   488d0595c8ffff       | mov                 byte ptr [esp + 0x2e], 0x7e
            //   4889442430           | mov                 byte ptr [esp + 0x29], 0x6e
            //   488d0555d9ffff       | mov                 byte ptr [esp + 0x2a], 0x74
            //   4889442428           | mov                 byte ptr [esp + 0x2b], 0x6b

        $sequence_4 = { 448bc8 4c8b442420 488b15???????? 488d4c2460 }
            // n = 4, score = 100
            //   448bc8               | inc                 ecx
            //   4c8b442420           | mov                 byte ptr [eax + edx], al
            //   488b15????????       |                     
            //   488d4c2460           | mov                 eax, 4

        $sequence_5 = { 48894c2408 4883ec78 ff15???????? 41b800010000 }
            // n = 4, score = 100
            //   48894c2408           | mov                 ecx, dword ptr [esp + 0x50]
            //   4883ec78             | dec                 eax
            //   ff15????????         |                     
            //   41b800010000         | add                 eax, 0x30

        $sequence_6 = { 85c0 742c 0fb6442421 8b4c2424 83c105 8bc9 488b942440010000 }
            // n = 7, score = 100
            //   85c0                 | mov                 edx, 0x3000
            //   742c                 | dec                 eax
            //   0fb6442421           | mov                 ecx, eax
            //   8b4c2424             | dec                 eax
            //   83c105               | mov                 dword ptr [esp + 0x28], eax
            //   8bc9                 | dec                 eax
            //   488b942440010000     | cmp                 dword ptr [esp + 0x28], 0

        $sequence_7 = { 488d0dad360000 e8???????? 41b840000000 ba00300000 b908000000 }
            // n = 5, score = 100
            //   488d0dad360000       | dec                 eax
            //   e8????????           |                     
            //   41b840000000         | lea                 edx, [0x2ad3]
            //   ba00300000           | dec                 eax
            //   b908000000           | mov                 ecx, dword ptr [esp + 0x48]

        $sequence_8 = { 837c245c00 7407 837c244000 7502 eb33 8b442440 }
            // n = 6, score = 100
            //   837c245c00           | mov                 eax, dword ptr [eax]
            //   7407                 | dec                 eax
            //   837c244000           | mov                 ecx, dword ptr [esp + 0x58]
            //   7502                 | dec                 eax
            //   eb33                 | add                 ecx, eax
            //   8b442440             | dec                 eax

        $sequence_9 = { 488bc1 4889842498000000 488b942498000000 488b8c24c8000000 }
            // n = 4, score = 100
            //   488bc1               | mov                 dword ptr [esp + 8], ecx
            //   4889842498000000     | dec                 eax
            //   488b942498000000     | sub                 esp, 0x138
            //   488b8c24c8000000     | dec                 eax

    condition:
        7 of them and filesize < 107520
}