rule win_datper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.datper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.datper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c64428ff21 45 4b 75ee 81c4a0000000 5d 5f }
            // n = 7, score = 200
            //   c64428ff21           | mov                 byte ptr [eax + ebp - 1], 0x21
            //   45                   | inc                 ebp
            //   4b                   | dec                 ebx
            //   75ee                 | jne                 0xfffffff0
            //   81c4a0000000         | add                 esp, 0xa0
            //   5d                   | pop                 ebp
            //   5f                   | pop                 edi

        $sequence_1 = { 8d8580feffff e8???????? c78588feffff04000000 33c0 }
            // n = 4, score = 200
            //   8d8580feffff         | lea                 eax, [ebp - 0x180]
            //   e8????????           |                     
            //   c78588feffff04000000     | mov    dword ptr [ebp - 0x178], 4
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 41 46 4a 85d2 75e8 5f 5e }
            // n = 7, score = 200
            //   41                   | inc                 ecx
            //   46                   | inc                 esi
            //   4a                   | dec                 edx
            //   85d2                 | test                edx, edx
            //   75e8                 | jne                 0xffffffea
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { 8b03 e8???????? 8b95d8efffff b8???????? e8???????? }
            // n = 5, score = 200
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   e8????????           |                     
            //   8b95d8efffff         | mov                 edx, dword ptr [ebp - 0x1028]
            //   b8????????           |                     
            //   e8????????           |                     

        $sequence_4 = { e8???????? 8d8500f0ffff 33c9 ba00100000 e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8d8500f0ffff         | lea                 eax, [ebp - 0x1000]
            //   33c9                 | xor                 ecx, ecx
            //   ba00100000           | mov                 edx, 0x1000
            //   e8????????           |                     

        $sequence_5 = { bf14000000 8d95c4d7ffff 8bcf a1???????? e8???????? }
            // n = 5, score = 200
            //   bf14000000           | mov                 edi, 0x14
            //   8d95c4d7ffff         | lea                 edx, [ebp - 0x283c]
            //   8bcf                 | mov                 ecx, edi
            //   a1????????           |                     
            //   e8????????           |                     

        $sequence_6 = { c78568d7ffff0c000000 33c0 89856cd7ffff c78570d7ffffffffffff 6a00 6a01 8d8568d7ffff }
            // n = 7, score = 200
            //   c78568d7ffff0c000000     | mov    dword ptr [ebp - 0x2898], 0xc
            //   33c0                 | xor                 eax, eax
            //   89856cd7ffff         | mov                 dword ptr [ebp - 0x2894], eax
            //   c78570d7ffffffffffff     | mov    dword ptr [ebp - 0x2890], 0xffffffff
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   8d8568d7ffff         | lea                 eax, [ebp - 0x2898]

        $sequence_7 = { b805000000 e8???????? 83c003 8bd8 85db 7e29 b81a000000 }
            // n = 7, score = 200
            //   b805000000           | mov                 eax, 5
            //   e8????????           |                     
            //   83c003               | add                 eax, 3
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   7e29                 | jle                 0x2b
            //   b81a000000           | mov                 eax, 0x1a

        $sequence_8 = { 8945f8 8d45fc ba00280000 e8???????? 8b4508 }
            // n = 5, score = 200
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   ba00280000           | mov                 edx, 0x2800
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_9 = { 030424 13542404 83c408 0fb600 }
            // n = 4, score = 200
            //   030424               | add                 eax, dword ptr [esp]
            //   13542404             | adc                 edx, dword ptr [esp + 4]
            //   83c408               | add                 esp, 8
            //   0fb600               | movzx               eax, byte ptr [eax]

    condition:
        7 of them and filesize < 253952
}