rule win_deadwood_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.deadwood."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deadwood"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b9???????? c645fcc6 e8???????? 68???????? b9???????? c645fcc7 }
            // n = 6, score = 100
            //   b9????????           |                     
            //   c645fcc6             | mov                 byte ptr [ebp - 4], 0xc6
            //   e8????????           |                     
            //   68????????           |                     
            //   b9????????           |                     
            //   c645fcc7             | mov                 byte ptr [ebp - 4], 0xc7

        $sequence_1 = { 68f0d8ffff 57 56 e8???????? 89442428 8954242c }
            // n = 6, score = 100
            //   68f0d8ffff           | push                0xffffd8f0
            //   57                   | push                edi
            //   56                   | push                esi
            //   e8????????           |                     
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   8954242c             | mov                 dword ptr [esp + 0x2c], edx

        $sequence_2 = { e8???????? 33c0 e9???????? 8975e4 33c0 39b8a0e34600 0f8491000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   33c0                 | xor                 eax, eax
            //   39b8a0e34600         | cmp                 dword ptr [eax + 0x46e3a0], edi
            //   0f8491000000         | je                  0x97

        $sequence_3 = { c1f803 57 83f828 0f8e27010000 40 99 83e207 }
            // n = 7, score = 100
            //   c1f803               | sar                 eax, 3
            //   57                   | push                edi
            //   83f828               | cmp                 eax, 0x28
            //   0f8e27010000         | jle                 0x12d
            //   40                   | inc                 eax
            //   99                   | cdq                 
            //   83e207               | and                 edx, 7

        $sequence_4 = { 895e14 385d0c 7409 c745e858f54500 eb06 8b4008 8945e8 }
            // n = 7, score = 100
            //   895e14               | mov                 dword ptr [esi + 0x14], ebx
            //   385d0c               | cmp                 byte ptr [ebp + 0xc], bl
            //   7409                 | je                  0xb
            //   c745e858f54500       | mov                 dword ptr [ebp - 0x18], 0x45f558
            //   eb06                 | jmp                 8
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_5 = { 52 c745fc04000000 e8???????? 8d4dd0 8d851cffffff e8???????? }
            // n = 6, score = 100
            //   52                   | push                edx
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   e8????????           |                     
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   8d851cffffff         | lea                 eax, [ebp - 0xe4]
            //   e8????????           |                     

        $sequence_6 = { 57 897dfc 57 c745c801000000 ff15???????? 8bf8 897dd0 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   57                   | push                edi
            //   c745c801000000       | mov                 dword ptr [ebp - 0x38], 1
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   897dd0               | mov                 dword ptr [ebp - 0x30], edi

        $sequence_7 = { 57 33db 6807020000 8d85f5fdffff 53 50 8bf1 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   6807020000           | push                0x207
            //   8d85f5fdffff         | lea                 eax, [ebp - 0x20b]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8bf1                 | mov                 esi, ecx

        $sequence_8 = { 8bc2 c1e81f 03c2 03f8 83c40c 897d14 85f6 }
            // n = 7, score = 100
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03c2                 | add                 eax, edx
            //   03f8                 | add                 edi, eax
            //   83c40c               | add                 esp, 0xc
            //   897d14               | mov                 dword ptr [ebp + 0x14], edi
            //   85f6                 | test                esi, esi

        $sequence_9 = { ffd5 8b4c241c 64890d00000000 59 5f 5e 5d }
            // n = 7, score = 100
            //   ffd5                 | call                ebp
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 1055744
}