rule win_decaf_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.decaf."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.decaf"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d6c2460 48c744247000000000 31c0 31c9 31d2 bb02000000 be67000000 }
            // n = 7, score = 100
            //   488d6c2460           | inc                 esp
            //   48c744247000000000     | movzx    ebp, byte ptr [esp + 0x87]
            //   31c0                 | inc                 esp
            //   31c9                 | movzx               edi, byte ptr [esp + 0x85]
            //   31d2                 | inc                 esp
            //   bb02000000           | mov                 byte ptr [esp + 0x62], bh
            //   be67000000           | inc                 esp

        $sequence_1 = { eb11 488d7818 488b8c2438240000 e8???????? 488b8c2470060000 48894808 833d????????00 }
            // n = 7, score = 100
            //   eb11                 | mov                 dword ptr [eax + 8], 0xe
            //   488d7818             | dec                 eax
            //   488b8c2438240000     | mov                 dword ptr [eax + 0x10], 0xe
            //   e8????????           |                     
            //   488b8c2470060000     | dec                 eax
            //   48894808             | mov                 ebx, dword ptr [esp + 0xb0]
            //   833d????????00       |                     

        $sequence_2 = { 44886c2446 440fb66c2464 44886c2445 440fb66c245d 44886c2444 440fb66c2466 44886c2443 }
            // n = 7, score = 100
            //   44886c2446           | dec                 eax
            //   440fb66c2464         | lea                 ecx, [0x170475]
            //   44886c2445           | mov                 edi, 4
            //   440fb66c245d         | nop                 
            //   44886c2444           | dec                 eax
            //   440fb66c2466         | lea                 eax, [0x14af54]
            //   44886c2443           | dec                 eax

        $sequence_3 = { e9???????? 4983f806 754d 4c8d4301 4c39c6 7331 488d051d4d0f00 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4983f806             | dec                 eax
            //   754d                 | mov                 ecx, dword ptr [esp + 0x2088]
            //   4c8d4301             | dec                 eax
            //   4c39c6               | mov                 dword ptr [eax + 0x18], ecx
            //   7331                 | jmp                 0x2aa
            //   488d051d4d0f00       | dec                 eax

        $sequence_4 = { eb14 488d7818 488b8c24081b0000 0f1f00 e8???????? 488b8c24080b0000 48894808 }
            // n = 7, score = 100
            //   eb14                 | dec                 eax
            //   488d7818             | lea                 eax, [0x263c2]
            //   488b8c24081b0000     | dec                 eax
            //   0f1f00               | mov                 ebp, dword ptr [esp + 0x88]
            //   e8????????           |                     
            //   488b8c24080b0000     | dec                 eax
            //   48894808             | add                 esp, 0x90

        $sequence_5 = { e8???????? 488b0d???????? 48898c24e0000000 488d052c9c1300 e8???????? 833d????????00 750e }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   48898c24e0000000     | dec                 eax
            //   488d052c9c1300       | mov                 edi, eax
            //   e8????????           |                     
            //   833d????????00       |                     
            //   750e                 | dec                 eax

        $sequence_6 = { 488b6c2410 4883c418 c3 488d05f5bb1b00 48890424 e8???????? 450f57ff }
            // n = 7, score = 100
            //   488b6c2410           | inc                 esp
            //   4883c418             | sub                 edx, eax
            //   c3                   | mov                 byte ptr [eax + 0x11], dl
            //   488d05f5bb1b00       | inc                 esp
            //   48890424             | movzx               eax, byte ptr [esp + 0x4c]
            //   e8????????           |                     
            //   450f57ff             | inc                 esp

        $sequence_7 = { e8???????? b911000000 4889c7 4889de 31c0 488d1d94e71700 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b911000000           | dec                 eax
            //   4889c7               | mov                 ecx, dword ptr [esp + 0x1338]
            //   4889de               | dec                 eax
            //   31c0                 | lea                 edi, [0x1ef3db]
            //   488d1d94e71700       | nop                 dword ptr [eax]
            //   e8????????           |                     

        $sequence_8 = { e8???????? 488b442478 488b4c2470 488b942488000000 ebbd 90 488d05bfff1d00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b442478           | mov                 edi, eax
            //   488b4c2470           | dec                 eax
            //   488b942488000000     | mov                 esi, ecx
            //   ebbd                 | dec                 eax
            //   90                   | mov                 eax, dword ptr [esp + 0x40]
            //   488d05bfff1d00       | mov                 word ptr [edi + ebx], 0x135f

        $sequence_9 = { eb14 488d7818 488b8c2470220000 0f1f00 e8???????? 488b8c24a8030000 48894808 }
            // n = 7, score = 100
            //   eb14                 | mov                 ebx, dword ptr [esp + 0x178]
            //   488d7818             | dec                 eax
            //   488b8c2470220000     | mov                 ecx, dword ptr [esp + 0x1d8]
            //   0f1f00               | dec                 eax
            //   e8????????           |                     
            //   488b8c24a8030000     | mov                 ebp, dword ptr [esp + 0x2b8]
            //   48894808             | dec                 eax

    condition:
        7 of them and filesize < 7193600
}