rule win_deeppost_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.deeppost."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deeppost"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7640 e8???????? 83c410 8b4e3c 85c9 740e 8b06 }
            // n = 7, score = 100
            //   ff7640               | push                dword ptr [esi + 0x40]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b4e3c               | mov                 ecx, dword ptr [esi + 0x3c]
            //   85c9                 | test                ecx, ecx
            //   740e                 | je                  0x10
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_1 = { e8???????? 83c40c 85c0 7440 6a06 68???????? 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7440                 | je                  0x42
            //   6a06                 | push                6
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_2 = { c1e708 0bca 0bf8 8b03 f780b800000000080000 7509 }
            // n = 6, score = 100
            //   c1e708               | shl                 edi, 8
            //   0bca                 | or                  ecx, edx
            //   0bf8                 | or                  edi, eax
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   f780b800000000080000     | test    dword ptr [eax + 0xb8], 0x800
            //   7509                 | jne                 0xb

        $sequence_3 = { 8bc3 c1e810 8bd6 0fb6c0 c1c208 0fb688589a4800 8bc3 }
            // n = 7, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   c1e810               | shr                 eax, 0x10
            //   8bd6                 | mov                 edx, esi
            //   0fb6c0               | movzx               eax, al
            //   c1c208               | rol                 edx, 8
            //   0fb688589a4800       | movzx               ecx, byte ptr [eax + 0x489a58]
            //   8bc3                 | mov                 eax, ebx

        $sequence_4 = { 8d85f0feffff 8bd7 53 ff7518 8bce 50 ff7510 }
            // n = 7, score = 100
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   8bd7                 | mov                 edx, edi
            //   53                   | push                ebx
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_5 = { 8bd3 e8???????? 85c0 0f85ce000000 8d8694000000 8d8f94000000 8945fc }
            // n = 7, score = 100
            //   8bd3                 | mov                 edx, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f85ce000000         | jne                 0xd4
            //   8d8694000000         | lea                 eax, [esi + 0x94]
            //   8d8f94000000         | lea                 ecx, [edi + 0x94]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_6 = { e8???????? 83c40c 837e1410 8b4d0c 894e10 720f 8b06 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   894e10               | mov                 dword ptr [esi + 0x10], ecx
            //   720f                 | jb                  0x11
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_7 = { e8???????? 83c408 85c0 0f84b4000000 6a00 c7404c805d4000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f84b4000000         | je                  0xba
            //   6a00                 | push                0
            //   c7404c805d4000       | mov                 dword ptr [eax + 0x4c], 0x405d80
            //   e8????????           |                     

        $sequence_8 = { e8???????? 83c40c 8d0cb500000000 51 8b4dfc ff7108 ff7708 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d0cb500000000       | lea                 ecx, [esi*4]
            //   51                   | push                ecx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   ff7108               | push                dword ptr [ecx + 8]
            //   ff7708               | push                dword ptr [edi + 8]

        $sequence_9 = { e8???????? 83c404 85c0 0f8533080000 b901000000 894dfc e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f8533080000         | jne                 0x839
            //   b901000000           | mov                 ecx, 1
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   e9????????           |                     

    condition:
        7 of them and filesize < 1332224
}