rule win_deltas_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.deltas."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deltas"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 56 8bf1 57 b940000000 33c0 }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 55 53 ff15???????? 85c0 7419 }
            // n = 5, score = 200
            //   55                   | push                ebp
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7419                 | je                  0x1b

        $sequence_2 = { 66ab 8d8c247c010000 6804010000 51 c64424146d }
            // n = 5, score = 200
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d8c247c010000       | lea                 ecx, [esp + 0x17c]
            //   6804010000           | push                0x104
            //   51                   | push                ecx
            //   c64424146d           | mov                 byte ptr [esp + 0x14], 0x6d

        $sequence_3 = { eb45 8b8c249c000000 8d442454 8d7c2454 bd10000000 8d7102 }
            // n = 6, score = 200
            //   eb45                 | jmp                 0x47
            //   8b8c249c000000       | mov                 ecx, dword ptr [esp + 0x9c]
            //   8d442454             | lea                 eax, [esp + 0x54]
            //   8d7c2454             | lea                 edi, [esp + 0x54]
            //   bd10000000           | mov                 ebp, 0x10
            //   8d7102               | lea                 esi, [ecx + 2]

        $sequence_4 = { 85c0 0f8485010000 8b9884000000 8b8888000000 81c38c000000 83f906 0f8733010000 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   0f8485010000         | je                  0x18b
            //   8b9884000000         | mov                 ebx, dword ptr [eax + 0x84]
            //   8b8888000000         | mov                 ecx, dword ptr [eax + 0x88]
            //   81c38c000000         | add                 ebx, 0x8c
            //   83f906               | cmp                 ecx, 6
            //   0f8733010000         | ja                  0x139

        $sequence_5 = { c1ef14 c1e10c 0bf9 8b4828 03fe 894c2438 8bcf }
            // n = 7, score = 200
            //   c1ef14               | shr                 edi, 0x14
            //   c1e10c               | shl                 ecx, 0xc
            //   0bf9                 | or                  edi, ecx
            //   8b4828               | mov                 ecx, dword ptr [eax + 0x28]
            //   03fe                 | add                 edi, esi
            //   894c2438             | mov                 dword ptr [esp + 0x38], ecx
            //   8bcf                 | mov                 ecx, edi

        $sequence_6 = { 8b7824 03f3 897c241c 8bfe 23ee f7d7 }
            // n = 6, score = 200
            //   8b7824               | mov                 edi, dword ptr [eax + 0x24]
            //   03f3                 | add                 esi, ebx
            //   897c241c             | mov                 dword ptr [esp + 0x1c], edi
            //   8bfe                 | mov                 edi, esi
            //   23ee                 | and                 ebp, esi
            //   f7d7                 | not                 edi

        $sequence_7 = { 88442423 8d442408 b164 b261 50 c644240c6b c644240e72 }
            // n = 7, score = 200
            //   88442423             | mov                 byte ptr [esp + 0x23], al
            //   8d442408             | lea                 eax, [esp + 8]
            //   b164                 | mov                 cl, 0x64
            //   b261                 | mov                 dl, 0x61
            //   50                   | push                eax
            //   c644240c6b           | mov                 byte ptr [esp + 0xc], 0x6b
            //   c644240e72           | mov                 byte ptr [esp + 0xe], 0x72

        $sequence_8 = { 3bc3 7413 8d542438 52 8b542444 53 53 }
            // n = 7, score = 200
            //   3bc3                 | cmp                 eax, ebx
            //   7413                 | je                  0x15
            //   8d542438             | lea                 edx, [esp + 0x38]
            //   52                   | push                edx
            //   8b542444             | mov                 edx, dword ptr [esp + 0x44]
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_9 = { 750e 8d4c2464 51 ffd6 898424c0000000 8d9424b0000000 52 }
            // n = 7, score = 200
            //   750e                 | jne                 0x10
            //   8d4c2464             | lea                 ecx, [esp + 0x64]
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   898424c0000000       | mov                 dword ptr [esp + 0xc0], eax
            //   8d9424b0000000       | lea                 edx, [esp + 0xb0]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 90112
}