rule win_deltastealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.deltastealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deltastealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb5d 31ff eb18 48314618 4889f1 e8???????? 488b4638 }
            // n = 7, score = 200
            //   eb5d                 | setae               cl
            //   31ff                 | dec                 eax
            //   eb18                 | lea                 edx, [0xa8af6]
            //   48314618             | dec                 ecx
            //   4889f1               | mov                 edx, dword ptr [esp + 0x10]
            //   e8????????           |                     
            //   488b4638             | jmp                 0x128

        $sequence_1 = { 4d89d7 40b601 83ff01 0f8583000000 4181fcff000000 0f873c050000 4885db }
            // n = 7, score = 200
            //   4d89d7               | je                  0x57b
            //   40b601               | dec                 ecx
            //   83ff01               | inc                 ebp
            //   0f8583000000         | dec                 ebp
            //   4181fcff000000       | mov                 ebp, eax
            //   0f873c050000         | dec                 ecx
            //   4885db               | mov                 esp, edx

        $sequence_2 = { e8???????? 8a5860 4889f9 e8???????? 448a7060 4889f9 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8a5860               | je                  0x557
            //   4889f9               | dec                 eax
            //   e8????????           |                     
            //   448a7060             | cmp                 dword ptr [esp + 0x488], 0
            //   4889f9               | sete                byte ptr [esp + 0xd0]
            //   e8????????           |                     

        $sequence_3 = { c3 4d89c8 e8???????? 0f0b 4157 4156 4155 }
            // n = 7, score = 200
            //   c3                   | xor                 ecx, ecx
            //   4d89c8               | ret                 
            //   e8????????           |                     
            //   0f0b                 | dec                 esp
            //   4157                 | mov                 edx, dword ptr [edx + 0x18]
            //   4156                 | dec                 ebp
            //   4155                 | test                edx, edx

        $sequence_4 = { e8???????? 4889f9 89ea e8???????? 41c60707 4883c438 5b }
            // n = 7, score = 200
            //   e8????????           |                     
            //   4889f9               | pop                 ebx
            //   89ea                 | pop                 edi
            //   e8????????           |                     
            //   41c60707             | dec                 eax
            //   4883c438             | mov                 ecx, esi
            //   5b                   | nop                 

        $sequence_5 = { 498b4e28 498b5630 41c60709 41c7471802000000 e8???????? 90 4883c438 }
            // n = 7, score = 200
            //   498b4e28             | dec                 ecx
            //   498b5630             | mov                 ecx, dword ptr [esi + 8]
            //   41c60709             | dec                 eax
            //   41c7471802000000     | test                ecx, ecx
            //   e8????????           |                     
            //   90                   | je                  0x2a
            //   4883c438             | dec                 ecx

        $sequence_6 = { eb18 488b4e40 4883c118 e8???????? e8???????? 488906 895608 }
            // n = 7, score = 200
            //   eb18                 | and                 dword ptr [esi], 0
            //   488b4e40             | dec                 eax
            //   4883c118             | add                 esp, 0x40
            //   e8????????           |                     
            //   e8????????           |                     
            //   488906               | jmp                 0x6b
            //   895608               | dec                 eax

        $sequence_7 = { e8???????? 0f0b ba08000000 4889f0 4883c420 5b 5f }
            // n = 7, score = 200
            //   e8????????           |                     
            //   0f0b                 | dec                 eax
            //   ba08000000           | sub                 esp, 0x30
            //   4889f0               | dec                 eax
            //   4883c420             | lea                 ebp, [edx + 0x60]
            //   5b                   | ud2                 
            //   5f                   | nop                 word ptr cs:[eax + eax]

        $sequence_8 = { e8???????? 4829fe 4c89f1 4889f2 4883c428 5b 5f }
            // n = 7, score = 200
            //   e8????????           |                     
            //   4829fe               | inc                 ecx
            //   4c89f1               | mov                 ecx, 5
            //   4889f2               | dec                 eax
            //   4883c428             | mov                 ecx, eax
            //   5b                   | dec                 esp
            //   5f                   | lea                 eax, [0xe2558]

        $sequence_9 = { 8b90cc000000 895108 83a0c400000000 e8???????? c70701000000 894704 }
            // n = 6, score = 200
            //   8b90cc000000         | mov                 cl, byte ptr [esp + 0xc1]
            //   895108               | mov                 byte ptr [esp + 0x27], cl
            //   83a0c400000000       | inc                 esp
            //   e8????????           |                     
            //   c70701000000         | mov                 dl, byte ptr [esp + 0xc2]
            //   894704               | mov                 eax, dword ptr [esp + 0x1b8]

    condition:
        7 of them and filesize < 3532800
}