rule win_deputy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.deputy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deputy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 6808020000 50 8d85e4f9ffff 50 e8???????? 83c40c }
            // n = 7, score = 100
            //   57                   | push                edi
            //   6808020000           | push                0x208
            //   50                   | push                eax
            //   8d85e4f9ffff         | lea                 eax, [ebp - 0x61c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_1 = { 58 6bc000 c780ac40001002000000 6a04 }
            // n = 4, score = 100
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   c780ac40001002000000     | mov    dword ptr [eax + 0x100040ac], 2
            //   6a04                 | push                4

        $sequence_2 = { 8d0436 50 6a00 57 8985ccf9ffff e8???????? }
            // n = 6, score = 100
            //   8d0436               | lea                 eax, [esi + esi]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   57                   | push                edi
            //   8985ccf9ffff         | mov                 dword ptr [ebp - 0x634], eax
            //   e8????????           |                     

        $sequence_3 = { ff15???????? eb6c 56 57 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   eb6c                 | jmp                 0x6e
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_4 = { 50 ff510c 85c0 0f85b0030000 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   ff510c               | call                dword ptr [ecx + 0xc]
            //   85c0                 | test                eax, eax
            //   0f85b0030000         | jne                 0x3b6

        $sequence_5 = { 8d85d0f9ffff 50 68???????? 68???????? ff15???????? 85c0 }
            // n = 6, score = 100
            //   8d85d0f9ffff         | lea                 eax, [ebp - 0x630]
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_6 = { 59 c3 e8???????? 85c0 0f843f070000 }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f843f070000         | je                  0x745

        $sequence_7 = { 0f1005???????? 66a1???????? 2bca d1f9 0f11844df4fdffff 6689844d04feffff 85db }
            // n = 7, score = 100
            //   0f1005????????       |                     
            //   66a1????????         |                     
            //   2bca                 | sub                 ecx, edx
            //   d1f9                 | sar                 ecx, 1
            //   0f11844df4fdffff     | movups              xmmword ptr [ebp + ecx*2 - 0x20c], xmm0
            //   6689844d04feffff     | mov                 word ptr [ebp + ecx*2 - 0x1fc], ax
            //   85db                 | test                ebx, ebx

        $sequence_8 = { e8???????? 83c40c 8d85ecfbffff 6804010000 50 ff35???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   6804010000           | push                0x104
            //   50                   | push                eax
            //   ff35????????         |                     

        $sequence_9 = { ffb5c8f9ffff 8bd8 8d85e0f9ffff ffb5ccf9ffff 56 53 50 }
            // n = 7, score = 100
            //   ffb5c8f9ffff         | push                dword ptr [ebp - 0x638]
            //   8bd8                 | mov                 ebx, eax
            //   8d85e0f9ffff         | lea                 eax, [ebp - 0x620]
            //   ffb5ccf9ffff         | push                dword ptr [ebp - 0x634]
            //   56                   | push                esi
            //   53                   | push                ebx
            //   50                   | push                eax

    condition:
        7 of them and filesize < 51200
}