rule win_deputydog_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.deputydog."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deputydog"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c20c00 56 8bf1 6a04 ff74240c 8d4624 50 }
            // n = 7, score = 100
            //   c20c00               | ret                 0xc
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   6a04                 | push                4
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   8d4624               | lea                 eax, [esi + 0x24]
            //   50                   | push                eax

        $sequence_1 = { ff15???????? 85c0 7424 8b45d8 8b55dc 6a14 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7424                 | je                  0x26
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8b55dc               | mov                 edx, dword ptr [ebp - 0x24]
            //   6a14                 | push                0x14

        $sequence_2 = { 8b7508 ff75f0 ff15???????? 57 6880000000 }
            // n = 5, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   57                   | push                edi
            //   6880000000           | push                0x80

        $sequence_3 = { 8b45f0 59 885dfc 59 8906 57 }
            // n = 6, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   59                   | pop                 ecx
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   59                   | pop                 ecx
            //   8906                 | mov                 dword ptr [esi], eax
            //   57                   | push                edi

        $sequence_4 = { c0e102 884dff eb35 83fa01 7511 8ac1 c0e804 }
            // n = 7, score = 100
            //   c0e102               | shl                 cl, 2
            //   884dff               | mov                 byte ptr [ebp - 1], cl
            //   eb35                 | jmp                 0x37
            //   83fa01               | cmp                 edx, 1
            //   7511                 | jne                 0x13
            //   8ac1                 | mov                 al, cl
            //   c0e804               | shr                 al, 4

        $sequence_5 = { 6a14 59 e8???????? 8b55d4 6a14 8945e4 8b45d0 }
            // n = 7, score = 100
            //   6a14                 | push                0x14
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   6a14                 | push                0x14
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]

        $sequence_6 = { 6a15 be???????? 59 bf???????? f3a5 8d8d74ffffff e8???????? }
            // n = 7, score = 100
            //   6a15                 | push                0x15
            //   be????????           |                     
            //   59                   | pop                 ecx
            //   bf????????           |                     
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8d8d74ffffff         | lea                 ecx, [ebp - 0x8c]
            //   e8????????           |                     

        $sequence_7 = { c645fc0a ff15???????? 8d8dccfeffff c645fc05 e8???????? 8d45cc }
            // n = 6, score = 100
            //   c645fc0a             | mov                 byte ptr [ebp - 4], 0xa
            //   ff15????????         |                     
            //   8d8dccfeffff         | lea                 ecx, [ebp - 0x134]
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   e8????????           |                     
            //   8d45cc               | lea                 eax, [ebp - 0x34]

        $sequence_8 = { 2bc8 c1f905 394df0 0f83e2000000 03c7 56 50 }
            // n = 7, score = 100
            //   2bc8                 | sub                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   394df0               | cmp                 dword ptr [ebp - 0x10], ecx
            //   0f83e2000000         | jae                 0xe8
            //   03c7                 | add                 eax, edi
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_9 = { 8808 eb53 83ff01 7518 8a0e }
            // n = 5, score = 100
            //   8808                 | mov                 byte ptr [eax], cl
            //   eb53                 | jmp                 0x55
            //   83ff01               | cmp                 edi, 1
            //   7518                 | jne                 0x1a
            //   8a0e                 | mov                 cl, byte ptr [esi]

    condition:
        7 of them and filesize < 90112
}