rule win_derohe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.derohe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.derohe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 8b542404 c6042443 8b02 ffd0 8b542404 c60424c9 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042443             | mov                 byte ptr [esp], 0x43
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424c9             | mov                 byte ptr [esp], 0xc9

        $sequence_1 = { ffd0 8b542404 c604247d 8b02 ffd0 8b542404 c60424b7 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c604247d             | mov                 byte ptr [esp], 0x7d
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424b7             | mov                 byte ptr [esp], 0xb7

        $sequence_2 = { e8???????? 5a 85c0 0f846b050000 8b742428 31c0 8b1f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   5a                   | pop                 edx
            //   85c0                 | test                eax, eax
            //   0f846b050000         | je                  0x571
            //   8b742428             | mov                 esi, dword ptr [esp + 0x28]
            //   31c0                 | xor                 eax, eax
            //   8b1f                 | mov                 ebx, dword ptr [edi]

        $sequence_3 = { ffd0 8b542404 c60424fe 8b02 ffd0 8b542404 c6042424 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424fe             | mov                 byte ptr [esp], 0xfe
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042424             | mov                 byte ptr [esp], 0x24

        $sequence_4 = { ffd0 8b542404 c60424d4 8b02 ffd0 8b542404 c6042464 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424d4             | mov                 byte ptr [esp], 0xd4
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042464             | mov                 byte ptr [esp], 0x64

        $sequence_5 = { ffd0 8b542404 c60424ae 8b02 ffd0 8b542404 c6042435 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424ae             | mov                 byte ptr [esp], 0xae
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c6042435             | mov                 byte ptr [esp], 0x35

        $sequence_6 = { ff702c ff15???????? 0fb7431c 897318 83e00a 83c410 6683f80a }
            // n = 7, score = 100
            //   ff702c               | push                dword ptr [eax + 0x2c]
            //   ff15????????         |                     
            //   0fb7431c             | movzx               eax, word ptr [ebx + 0x1c]
            //   897318               | mov                 dword ptr [ebx + 0x18], esi
            //   83e00a               | and                 eax, 0xa
            //   83c410               | add                 esp, 0x10
            //   6683f80a             | cmp                 ax, 0xa

        $sequence_7 = { ffd0 8b542404 c604245f 8b02 ffd0 8b542404 c60424f5 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c604245f             | mov                 byte ptr [esp], 0x5f
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424f5             | mov                 byte ptr [esp], 0xf5

        $sequence_8 = { ffd0 8b542404 c60424ba 8b02 ffd0 8b542404 c60424c5 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424ba             | mov                 byte ptr [esp], 0xba
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   ffd0                 | call                eax
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   c60424c5             | mov                 byte ptr [esp], 0xc5

        $sequence_9 = { e8???????? 8b542414 8b4318 2982d4000000 8b4718 89c1 81e110900000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8b4318               | mov                 eax, dword ptr [ebx + 0x18]
            //   2982d4000000         | sub                 dword ptr [edx + 0xd4], eax
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]
            //   89c1                 | mov                 ecx, eax
            //   81e110900000         | and                 ecx, 0x9010

    condition:
        7 of them and filesize < 35788800
}