rule win_devilstongue_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.devilstongue."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.devilstongue"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b442430 b9daa5a546 ebbb 4889442428 488b442428 4889442420 4889f9 }
            // n = 7, score = 100
            //   488b442430           | inc                 ebp
            //   b9daa5a546           | xor                 eax, eax
            //   ebbb                 | dec                 eax
            //   4889442428           | mov                 ecx, dword ptr [esp + 0x48]
            //   488b442428           | dec                 eax
            //   4889442420           | xor                 ecx, esp
            //   4889f9               | dec                 eax

        $sequence_1 = { b8be144e7b 3db15f1d58 744c 3dbe144e7b 75f2 488b7c2420 }
            // n = 6, score = 100
            //   b8be144e7b           | cmp                 eax, 0xfb1579a8
            //   3db15f1d58           | jle                 0x2e9
            //   744c                 | mov                 eax, 0x7f5a6953
            //   3dbe144e7b           | jmp                 0x27b
            //   75f2                 | mov                 eax, 0xc87eb0f5
            //   488b7c2420           | jmp                 0x27b

        $sequence_2 = { 3dea84e30c 741d 3d140a3916 75b7 807c242f00 b81ec8dc61 0f45c6 }
            // n = 7, score = 100
            //   3dea84e30c           | mov                 eax, dword ptr [esp + 0x48]
            //   741d                 | cmp                 eax, 0x930c8706
            //   3d140a3916           | je                  0x2cc
            //   75b7                 | cmp                 eax, 0x96eb592b
            //   807c242f00           | jne                 0x2a7
            //   b81ec8dc61           | dec                 eax
            //   0f45c6               | mov                 ecx, ebp

        $sequence_3 = { 488d0d5edf0100 48894c05b0 488b45b0 48634004 8d8850ffffff 894c05ac 488d4dc0 }
            // n = 7, score = 100
            //   488d0d5edf0100       | mov                 ecx, dword ptr [esp + 0x60]
            //   48894c05b0           | mov                 edx, 0xa4ece28c
            //   488b45b0             | cmp                 edx, 0x81f9b2ee
            //   48634004             | je                  0x5e1
            //   8d8850ffffff         | cmp                 edx, 0xa4ece28c
            //   894c05ac             | jne                 0x542
            //   488d4dc0             | mov                 edx, 0x96eb592b

        $sequence_4 = { ebe1 488b45b8 488b45b0 b9bd77097c 488b75e8 81f9316958ca 7436 }
            // n = 7, score = 100
            //   ebe1                 | mov                 dword ptr [ebp + 0x28], 0xffffffff
            //   488b45b8             | mov                 ecx, 0x40196861
            //   488b45b0             | mov                 eax, dword ptr [ebp + 0x2c]
            //   b9bd77097c           | mov                 eax, 0x9cabf57a
            //   488b75e8             | mov                 bl, 1
            //   81f9316958ca         | mov                 eax, 0xa15dcd63
            //   7436                 | inc                 esp

        $sequence_5 = { 4881c4e0040000 5f 5e 5d 48ff6018 488d4da8 e8???????? }
            // n = 7, score = 100
            //   4881c4e0040000       | cmp                 eax, 0x8671fb3
            //   5f                   | je                  0x1d04
            //   5e                   | cmp                 eax, 0x15728fc9
            //   5d                   | jne                 0x194e
            //   48ff6018             | mov                 eax, 0x8b8cf219
            //   488d4da8             | dec                 eax
            //   e8????????           |                     

        $sequence_6 = { 4883ec28 488d6c2420 48c74500feffffff 4889ce 488d05f9750300 488901 488d4108 }
            // n = 7, score = 100
            //   4883ec28             | xor                 eax, eax
            //   488d6c2420           | dec                 ecx
            //   48c74500feffffff     | mov                 eax, dword ptr [esp + 0x10]
            //   4889ce               | dec                 eax
            //   488d05f9750300       | mov                 ecx, eax
            //   488901               | dec                 eax
            //   488d4108             | sub                 ecx, edi

        $sequence_7 = { 4889d9 4889f2 4d89c1 e8???????? 4989c4 b9abd62222 81f92832a1a7 }
            // n = 7, score = 100
            //   4889d9               | and                 edx, 7
            //   4889f2               | dec                 eax
            //   4d89c1               | xor                 ecx, 7
            //   e8????????           |                     
            //   4989c4               | dec                 eax
            //   b9abd62222           | or                  ecx, edx
            //   81f92832a1a7         | dec                 eax

        $sequence_8 = { 75f2 488d0dd3030500 48890f 488b4f08 ffd6 b862579455 }
            // n = 6, score = 100
            //   75f2                 | dec                 eax
            //   488d0dd3030500       | mov                 eax, dword ptr [eax]
            //   48890f               | dec                 eax
            //   488b4f08             | mov                 dword ptr [ebp], eax
            //   ffd6                 | mov                 eax, 0xb8144b41
            //   b862579455           | jmp                 0x6ba

        $sequence_9 = { 3d1bc2c8c1 0f8582feffff b88853f001 3d7f2a6238 0f84f7010000 3d8853f001 75ee }
            // n = 7, score = 100
            //   3d1bc2c8c1           | cmp                 eax, 0xc30163f9
            //   0f8582feffff         | jne                 0xb9c
            //   b88853f001           | mov                 eax, 0x10
            //   3d7f2a6238           | dec                 eax
            //   0f84f7010000         | sub                 esp, eax
            //   3d8853f001           | dec                 eax
            //   75ee                 | mov                 eax, esp

    condition:
        7 of them and filesize < 990208
}