rule win_devopt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.devopt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.devopt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb47 8b45fc 0fb6809e030000 50 8b45fc 8a889d030000 8b45fc }
            // n = 7, score = 100
            //   eb47                 | jmp                 0x49
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0fb6809e030000       | movzx               eax, byte ptr [eax + 0x39e]
            //   50                   | push                eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8a889d030000         | mov                 cl, byte ptr [eax + 0x39d]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_1 = { ff15???????? 8b45f4 8d4060 50 6863090000 6a00 6a09 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8d4060               | lea                 eax, [eax + 0x60]
            //   50                   | push                eax
            //   6863090000           | push                0x963
            //   6a00                 | push                0
            //   6a09                 | push                9

        $sequence_2 = { eb0f 8b45fc 8b4050 8b55fc 8b4dfc ff514c 89ec }
            // n = 7, score = 100
            //   eb0f                 | jmp                 0x11
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4050               | mov                 eax, dword ptr [eax + 0x50]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   ff514c               | call                dword ptr [ecx + 0x4c]
            //   89ec                 | mov                 esp, ebp

        $sequence_3 = { f77dac 0fb755cc 8d0410 66894588 0fb745c6 0fb755ce 29d0 }
            // n = 7, score = 100
            //   f77dac               | idiv                dword ptr [ebp - 0x54]
            //   0fb755cc             | movzx               edx, word ptr [ebp - 0x34]
            //   8d0410               | lea                 eax, [eax + edx]
            //   66894588             | mov                 word ptr [ebp - 0x78], ax
            //   0fb745c6             | movzx               eax, word ptr [ebp - 0x3a]
            //   0fb755ce             | movzx               edx, word ptr [ebp - 0x32]
            //   29d0                 | sub                 eax, edx

        $sequence_4 = { eb36 807dd8b3 7530 0fb645d4 2d80000000 83f824 7322 }
            // n = 7, score = 100
            //   eb36                 | jmp                 0x38
            //   807dd8b3             | cmp                 byte ptr [ebp - 0x28], 0xb3
            //   7530                 | jne                 0x32
            //   0fb645d4             | movzx               eax, byte ptr [ebp - 0x2c]
            //   2d80000000           | sub                 eax, 0x80
            //   83f824               | cmp                 eax, 0x24
            //   7322                 | jae                 0x24

        $sequence_5 = { ff526c 8845f0 660fb645f0 66250100 66a9ffff 7502 eb09 }
            // n = 7, score = 100
            //   ff526c               | call                dword ptr [edx + 0x6c]
            //   8845f0               | mov                 byte ptr [ebp - 0x10], al
            //   660fb645f0           | movzx               ax, byte ptr [ebp - 0x10]
            //   66250100             | and                 ax, 1
            //   66a9ffff             | test                ax, 0xffff
            //   7502                 | jne                 4
            //   eb09                 | jmp                 0xb

        $sequence_6 = { eb2a 6a00 8d45e8 50 66b90000 66ba0000 66b80000 }
            // n = 7, score = 100
            //   eb2a                 | jmp                 0x2c
            //   6a00                 | push                0
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   66b90000             | mov                 cx, 0
            //   66ba0000             | mov                 dx, 0
            //   66b80000             | mov                 ax, 0

        $sequence_7 = { eb46 8b45fc 8b4034 8b55fc 8b4dfc 8b4934 ff91fc000000 }
            // n = 7, score = 100
            //   eb46                 | jmp                 0x48
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4034               | mov                 eax, dword ptr [eax + 0x34]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b4934               | mov                 ecx, dword ptr [ecx + 0x34]
            //   ff91fc000000         | call                dword ptr [ecx + 0xfc]

        $sequence_8 = { e8???????? 8d7600 b801000000 89f1 d3e0 8d50ff 21da }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d7600               | lea                 esi, [esi]
            //   b801000000           | mov                 eax, 1
            //   89f1                 | mov                 ecx, esi
            //   d3e0                 | shl                 eax, cl
            //   8d50ff               | lea                 edx, [eax - 1]
            //   21da                 | and                 edx, ebx

        $sequence_9 = { ff75c0 8b4dbc 8b55c4 8d45ec e8???????? 84c0 7509 }
            // n = 7, score = 100
            //   ff75c0               | push                dword ptr [ebp - 0x40]
            //   8b4dbc               | mov                 ecx, dword ptr [ebp - 0x44]
            //   8b55c4               | mov                 edx, dword ptr [ebp - 0x3c]
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7509                 | jne                 0xb

    condition:
        7 of them and filesize < 4645888
}