rule win_dexbia_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dexbia."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dexbia"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66ab aa b9ff040000 33c0 8dbc249d260000 be???????? f3ab }
            // n = 7, score = 200
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b9ff040000           | mov                 ecx, 0x4ff
            //   33c0                 | xor                 eax, eax
            //   8dbc249d260000       | lea                 edi, [esp + 0x269d]
            //   be????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_1 = { 8d8ef8000000 8d9638010000 51 52 e8???????? 83c408 }
            // n = 6, score = 200
            //   8d8ef8000000         | lea                 ecx, [esi + 0xf8]
            //   8d9638010000         | lea                 edx, [esi + 0x138]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_2 = { 8bca 83c020 83e103 8d9424a0120000 f3a4 8d8c24a0260000 }
            // n = 6, score = 200
            //   8bca                 | mov                 ecx, edx
            //   83c020               | add                 eax, 0x20
            //   83e103               | and                 ecx, 3
            //   8d9424a0120000       | lea                 edx, [esp + 0x12a0]
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d8c24a0260000       | lea                 ecx, [esp + 0x26a0]

        $sequence_3 = { 72c1 8b4508 c705????????01000000 50 a3???????? e8???????? 8db6ec894000 }
            // n = 7, score = 200
            //   72c1                 | jb                  0xffffffc3
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c705????????01000000     |     
            //   50                   | push                eax
            //   a3????????           |                     
            //   e8????????           |                     
            //   8db6ec894000         | lea                 esi, [esi + 0x4089ec]

        $sequence_4 = { 60 55 40 008c554000b055 }
            // n = 4, score = 200
            //   60                   | pushal              
            //   55                   | push                ebp
            //   40                   | inc                 eax
            //   008c554000b055       | add                 byte ptr [ebp + edx*2 + 0x55b00040], cl

        $sequence_5 = { 81c444040000 68a00f0000 ffd5 e9???????? 53 8d8c2418100000 53 }
            // n = 7, score = 200
            //   81c444040000         | add                 esp, 0x444
            //   68a00f0000           | push                0xfa0
            //   ffd5                 | call                ebp
            //   e9????????           |                     
            //   53                   | push                ebx
            //   8d8c2418100000       | lea                 ecx, [esp + 0x1018]
            //   53                   | push                ebx

        $sequence_6 = { e8???????? 8d942468040000 50 52 68???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8d942468040000       | lea                 edx, [esp + 0x468]
            //   50                   | push                eax
            //   52                   | push                edx
            //   68????????           |                     

        $sequence_7 = { 8bb42480010000 8bbc2484010000 c744241400000000 6a64 }
            // n = 4, score = 200
            //   8bb42480010000       | mov                 esi, dword ptr [esp + 0x180]
            //   8bbc2484010000       | mov                 edi, dword ptr [esp + 0x184]
            //   c744241400000000     | mov                 dword ptr [esp + 0x14], 0
            //   6a64                 | push                0x64

        $sequence_8 = { 85c0 0f85e5feffff 8bd7 b9ff090000 8dbc2455040000 88842454040000 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   0f85e5feffff         | jne                 0xfffffeeb
            //   8bd7                 | mov                 edx, edi
            //   b9ff090000           | mov                 ecx, 0x9ff
            //   8dbc2455040000       | lea                 edi, [esp + 0x455]
            //   88842454040000       | mov                 byte ptr [esp + 0x454], al

        $sequence_9 = { 33c0 8d7c247d c644247c00 f3ab 66ab aa }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   8d7c247d             | lea                 edi, [esp + 0x7d]
            //   c644247c00           | mov                 byte ptr [esp + 0x7c], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al

    condition:
        7 of them and filesize < 106496
}