rule win_dexter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dexter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dexter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a59 ff15???????? 85c0 7414 68???????? 8b4d08 }
            // n = 6, score = 400
            //   6a59                 | push                0x59
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   68????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_1 = { 50 6a00 ff15???????? 68???????? 68???????? }
            // n = 5, score = 400
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_2 = { 8b0d???????? 51 ff15???????? 8b15???????? 8955fc 8b45fc 50 }
            // n = 7, score = 400
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b15????????         |                     
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax

        $sequence_3 = { 8b45fc 50 ff15???????? 8b0d???????? 51 ff15???????? ebc6 }
            // n = 7, score = 400
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   ebc6                 | jmp                 0xffffffc8

        $sequence_4 = { 83c40c 68???????? ff15???????? 6a00 6a00 6a00 6a00 }
            // n = 7, score = 400
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { e9???????? 6a59 ff15???????? 85c0 7514 68???????? 8b4d08 }
            // n = 7, score = 400
            //   e9????????           |                     
            //   6a59                 | push                0x59
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16
            //   68????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_6 = { e8???????? 83c410 8b4508 50 8b4d10 }
            // n = 5, score = 400
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]

        $sequence_7 = { ff15???????? 6a4a 6a00 68???????? e8???????? 83c40c 6a4a }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   6a4a                 | push                0x4a
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a4a                 | push                0x4a

        $sequence_8 = { 7514 68???????? 8b5508 52 ff15???????? e9???????? }
            // n = 6, score = 400
            //   7514                 | jne                 0x16
            //   68????????           |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_9 = { 51 6a08 8b15???????? 52 ff15???????? 8945f8 }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   6a08                 | push                8
            //   8b15????????         |                     
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

    condition:
        7 of them and filesize < 98304
}