rule win_dinodas_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dinodas_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dinodas_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 33c9 83c404 8975ec 3bf1 745c 8b4704 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   33c9                 | xor                 ecx, ecx
            //   83c404               | add                 esp, 4
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   3bf1                 | cmp                 esi, ecx
            //   745c                 | je                  0x5e
            //   8b4704               | mov                 eax, dword ptr [edi + 4]

        $sequence_1 = { ffd2 8b9d94fdffff 8d8da0fdffff 51 53 ff15???????? }
            // n = 6, score = 100
            //   ffd2                 | call                edx
            //   8b9d94fdffff         | mov                 ebx, dword ptr [ebp - 0x26c]
            //   8d8da0fdffff         | lea                 ecx, [ebp - 0x260]
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_2 = { c745a80f000000 e8???????? c645fc01 a1???????? 6aff 50 ff15???????? }
            // n = 7, score = 100
            //   c745a80f000000       | mov                 dword ptr [ebp - 0x58], 0xf
            //   e8????????           |                     
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   a1????????           |                     
            //   6aff                 | push                -1
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { 8d45b4 e9???????? 8d45a8 e9???????? 8d75d4 e9???????? 8d75b8 }
            // n = 7, score = 100
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   e9????????           |                     
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   e9????????           |                     
            //   8d75d4               | lea                 esi, [ebp - 0x2c]
            //   e9????????           |                     
            //   8d75b8               | lea                 esi, [ebp - 0x48]

        $sequence_4 = { 6a00 6a01 ff15???????? 8bf8 85ff 741a 6a00 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   741a                 | je                  0x1c
            //   6a00                 | push                0

        $sequence_5 = { 8d4d9c 68???????? 51 e8???????? 83c40c 397594 720c }
            // n = 7, score = 100
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   397594               | cmp                 dword ptr [ebp - 0x6c], esi
            //   720c                 | jb                  0xe

        $sequence_6 = { 8bce 8bf3 83f804 7217 8d4900 8b16 3b11 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   8bf3                 | mov                 esi, ebx
            //   83f804               | cmp                 eax, 4
            //   7217                 | jb                  0x19
            //   8d4900               | lea                 ecx, [ecx]
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   3b11                 | cmp                 edx, dword ptr [ecx]

        $sequence_7 = { 8b4204 ffd0 8b4d0c 51 e8???????? 83c404 8937 }
            // n = 7, score = 100
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   ffd0                 | call                eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8937                 | mov                 dword ptr [edi], esi

        $sequence_8 = { 83e810 e8???????? 8d7010 8975c4 c645fc07 8b4714 }
            // n = 6, score = 100
            //   83e810               | sub                 eax, 0x10
            //   e8????????           |                     
            //   8d7010               | lea                 esi, [eax + 0x10]
            //   8975c4               | mov                 dword ptr [ebp - 0x3c], esi
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]

        $sequence_9 = { 8d75b8 e9???????? 8d759c e9???????? 8db578ffffff e9???????? 8db548ffffff }
            // n = 7, score = 100
            //   8d75b8               | lea                 esi, [ebp - 0x48]
            //   e9????????           |                     
            //   8d759c               | lea                 esi, [ebp - 0x64]
            //   e9????????           |                     
            //   8db578ffffff         | lea                 esi, [ebp - 0x88]
            //   e9????????           |                     
            //   8db548ffffff         | lea                 esi, [ebp - 0xb8]

    condition:
        7 of them and filesize < 638976
}