rule win_dircrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.dircrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dircrypt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 6a00 e8???????? 05d6070000 50 }
            // n = 6, score = 900
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a00                 | push                0
            //   e8????????           |                     
            //   05d6070000           | add                 eax, 0x7d6
            //   50                   | push                eax

        $sequence_1 = { e8???????? 03f0 8d45dc 50 e8???????? }
            // n = 5, score = 900
            //   e8????????           |                     
            //   03f0                 | add                 esi, eax
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { e8???????? 05d3070000 50 6a01 }
            // n = 4, score = 900
            //   e8????????           |                     
            //   05d3070000           | add                 eax, 0x7d3
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_3 = { 833d????????00 751a 68???????? e8???????? 05d2070000 50 e8???????? }
            // n = 7, score = 900
            //   833d????????00       |                     
            //   751a                 | jne                 0x1c
            //   68????????           |                     
            //   e8????????           |                     
            //   05d2070000           | add                 eax, 0x7d2
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_4 = { 751a 68???????? e8???????? 05d2070000 50 }
            // n = 5, score = 900
            //   751a                 | jne                 0x1c
            //   68????????           |                     
            //   e8????????           |                     
            //   05d2070000           | add                 eax, 0x7d2
            //   50                   | push                eax

        $sequence_5 = { 833d????????00 7514 c705????????01000000 e8???????? }
            // n = 4, score = 900
            //   833d????????00       |                     
            //   7514                 | jne                 0x16
            //   c705????????01000000     |     
            //   e8????????           |                     

        $sequence_6 = { c705????????01000000 e8???????? e8???????? 833d????????00 7514 }
            // n = 5, score = 900
            //   c705????????01000000     |     
            //   e8????????           |                     
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7514                 | jne                 0x16

        $sequence_7 = { 6801000080 e8???????? e8???????? e8???????? e8???????? }
            // n = 5, score = 900
            //   6801000080           | push                0x80000001
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 05d2070000 50 e8???????? a3???????? 6a13 68???????? }
            // n = 6, score = 900
            //   05d2070000           | add                 eax, 0x7d2
            //   50                   | push                eax
            //   e8????????           |                     
            //   a3????????           |                     
            //   6a13                 | push                0x13
            //   68????????           |                     

        $sequence_9 = { 833d????????00 7536 c705????????01000000 e8???????? }
            // n = 4, score = 900
            //   833d????????00       |                     
            //   7536                 | jne                 0x38
            //   c705????????01000000     |     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 671744
}